/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers.sys;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.Hotkey;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.IHotkeyService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class HotkeyController
extends BaseController {
    @Autowired
    private IHotkeyService service;

    @RequestMapping(value={"/sys/hotkey/query"})
    @ResponseBody
    public ResponseData query(Hotkey dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        dto.setHotkeyLevel("system");
        dto.setHotkeyLevelId(0L);
        return new ResponseData(this.service.selectOptions(requestContext, dto, null));
    }

    @RequestMapping(value={"/sys/preference/hotkey/query"})
    public ModelAndView preferenceQuery(HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        ModelAndView view = new ModelAndView();
        view.setViewName("/sys/um/sys_preference_hotkey");
        List<Hotkey> hotkeys = this.service.preferenceQuery(requestContext);
        view.addObject("hotkeys", hotkeys);
        return view;
    }

    @RequestMapping(value={"/sys/hotkey/submit"})
    @ResponseBody
    public ResponseData update(@RequestBody List<Hotkey> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/sys/hotkey/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<Hotkey> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }
}

