/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.service.impl;

import com.hand.hap.account.dto.User;
import com.hand.hap.account.exception.RoleException;
import com.hand.hap.account.service.IRole;
import com.hand.hap.account.service.IRoleService;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.core.components.CaptchaConfig;
import com.hand.hap.core.components.SysConfigManager;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.core.util.TimeZoneUtil;
import com.hand.hap.hr.service.IEmployeeAssignService;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.message.websocket.CommandMessage;
import com.hand.hap.security.IAuthenticationSuccessListener;
import com.hand.hap.security.TokenUtils;
import com.hand.hap.system.dto.SysPreferences;
import com.hand.hap.system.service.ISysPreferencesService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.WebUtils;

@Component
public class DefaultAuthenticationSuccessListener
implements IAuthenticationSuccessListener {
    @Autowired
    private IUserService userService;
    @Autowired
    @Qualifier(value="roleServiceImpl")
    private IRoleService roleService;
    @Autowired
    private ISysPreferencesService preferencesService;
    @Autowired
    private IEmployeeAssignService employeeAssignService;
    @Autowired
    private CaptchaConfig captchaConfig;
    @Autowired
    private SysConfigManager sysConfigManager;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private IMessagePublisher iMessagePublisher;
    @Value(value="${sys.user.security.generate.accesstoken:false}")
    private boolean generateAccessToken;
    private static final String HAP_LOGIN_USER = "hap:cache:login:";

    @Override
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        UserDetails userDetails = (UserDetails)authentication.getPrincipal();
        User user = this.userService.convertToUser(userDetails);
        HttpSession session = request.getSession(true);
        this.processRepeatLogin(user, session);
        session.setAttribute("userId", (Object)user.getUserId());
        session.setAttribute("userName", (Object)user.getUserName());
        session.setAttribute("locale", (Object)locale.toString());
        SysPreferences preference = new SysPreferences();
        preference.setUserId(user.getUserId());
        List<SysPreferences> preferences = this.preferencesService.querySysPreferences(RequestHelper.newEmptyRequest(), preference);
        this.setTimeZoneFromPreference(request, this.getPreferences(preferences, "timeZone"));
        this.setNavFromPreference(session, this.getPreferences(preferences, "nav"));
        this.setLocalePreference(request, this.getPreferences(preferences, "locale"));
        this.setRoleInfo(request, session, user);
        this.setProcessUser(user, session);
        this.setCompany(user, session);
        this.generateSecurityKey(session);
        this.fetchSystemImageVersion(request);
        this.captchaConfig.resetLoginFailureInfo(request, response);
    }

    @Override
    public int getOrder() {
        return 0;
    }

    private void fetchSystemImageVersion(HttpServletRequest request) {
        WebUtils.setSessionAttribute((HttpServletRequest)request, (String)"sysLogoVersion", (Object)this.sysConfigManager.getSystemLogoVersion());
        WebUtils.setSessionAttribute((HttpServletRequest)request, (String)"sysFaviconVersion", (Object)this.sysConfigManager.getSystemFaviconVersion());
    }

    private void processRepeatLogin(User user, HttpSession session) {
        String existSessionId = (String)this.redisTemplate.opsForValue().get((Object)(HAP_LOGIN_USER + user.getUserName()));
        this.redisTemplate.opsForValue().set((Object)(HAP_LOGIN_USER + user.getUserName()), (Object)session.getId(), (long)session.getMaxInactiveInterval(), TimeUnit.SECONDS);
        if (existSessionId != null && !existSessionId.equals(session.getId()) && this.sysConfigManager.isProhibitRepeatLogin()) {
            CommandMessage commandMessage = new CommandMessage();
            commandMessage.setSessionId(session.getId());
            commandMessage.setUserName(user.getUserName());
            commandMessage.setAction("SYS_REPEAT_LOGIN");
            this.iMessagePublisher.publish("webSocket", commandMessage);
        }
    }

    private void setProcessUser(User user, HttpSession session) {
        if (user.getEmployeeId() != null) {
            session.setAttribute("employeeId", (Object)user.getEmployeeId());
            session.setAttribute("employeeCode", (Object)user.getEmployeeCode());
        }
    }

    private void setCompany(User user, HttpSession session) {
        Long companyId;
        if (user.getEmployeeId() != null && (companyId = this.employeeAssignService.getCompanyByEmployeeId(user.getEmployeeId())) != null) {
            session.setAttribute("companyId", (Object)companyId);
        }
    }

    private void setTimeZoneFromPreference(HttpServletRequest request, SysPreferences pref) {
        String tz;
        String string = tz = pref == null ? null : pref.getPreferencesValue();
        if (org.apache.commons.lang.StringUtils.isBlank((String)tz)) {
            String appServletContextKey = FrameworkServlet.SERVLET_CONTEXT_PREFIX + "appServlet";
            WebApplicationContext appContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext(), (String)appServletContextKey);
            TimeZone timeZone = ((SessionLocaleResolver)appContext.getBean(SessionLocaleResolver.class)).getDefaultTimeZone();
            tz = TimeZoneUtil.toGMTFormat(timeZone == null ? TimeZone.getDefault() : timeZone);
        }
        WebUtils.setSessionAttribute((HttpServletRequest)request, (String)SessionLocaleResolver.TIME_ZONE_SESSION_ATTRIBUTE_NAME, (Object)StringUtils.parseTimeZoneString((String)tz));
        request.getSession(true).setAttribute("timeZone", (Object)tz);
    }

    private void setNavFromPreference(HttpSession session, SysPreferences pref) {
        String nav = pref == null ? null : pref.getPreferencesValue();
        session.setAttribute("nav", (Object)nav);
    }

    private void setLocalePreference(HttpServletRequest request, SysPreferences pref) {
        if (pref != null) {
            WebUtils.setSessionAttribute((HttpServletRequest)request, (String)SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME, (Object)StringUtils.parseLocaleString((String)pref.getPreferencesValue()));
        }
    }

    private void setRoleInfo(HttpServletRequest request, HttpSession session, User user) {
        List<IRole> roles = this.roleService.selectActiveRolesByUser(RequestHelper.createServiceRequest(request), user);
        if (roles.isEmpty()) {
            request.setAttribute("code", (Object)"NO_ROLE");
            throw new RuntimeException(new RoleException(null, "error.account_no_role", null));
        }
        if (this.sysConfigManager.getRoleMergeFlag()) {
            ArrayList<Long> roleIds = new ArrayList<Long>();
            for (IRole role : roles) {
                roleIds.add(role.getRoleId());
            }
            Long[] ids = roleIds.toArray(new Long[roleIds.size()]);
            session.setAttribute("roleIds", (Object)ids);
            session.setAttribute("roleId", (Object)roles.get(0).getRoleId());
        }
    }

    private String generateSecurityKey(HttpSession session) {
        return TokenUtils.setSecurityKey(session);
    }

    private SysPreferences getPreferences(List<SysPreferences> preferencesList, String preferenceName) {
        for (SysPreferences pref : preferencesList) {
            if (!preferenceName.equals(pref.getPreferences())) continue;
            return pref;
        }
        return null;
    }
}

