/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.service.imp;

import com.hand.hap.security.IAuthenticationSuccessListener;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.request.DefaultOAuth2RequestFactory;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.stereotype.Component;

@Component
public class GenerateTokenAuthenticationSuccessListener
implements IAuthenticationSuccessListener {
    @Autowired
    private AuthorizationServerTokenServices tokenServices;
    @Autowired
    private DefaultOAuth2RequestFactory defaultOAuth2RequestFactory;
    @Value(value="${sys.user.security.generate.accesstoken:false}")
    private boolean generateAccessToken;

    @Override
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        HttpSession session = request.getSession(false);
        if (this.generateAccessToken) {
            this.generateAccessToken(authentication, session);
        }
    }

    private void generateAccessToken(Authentication authentication, HttpSession session) {
        HashMap<String, String> authorizationParameters = new HashMap<String, String>(5);
        authorizationParameters.put("client_id", "HAP_INNER_CLIENT_ID");
        authorizationParameters.put("client_secret", "2d6be1aa-5e3b-4b03-b8c9-d553ea276a05");
        authorizationParameters.put("grant_type", "password");
        AuthorizationRequest authorizationRequest = this.defaultOAuth2RequestFactory.createAuthorizationRequest(authorizationParameters);
        OAuth2Request oAuth2Request = this.defaultOAuth2RequestFactory.createOAuth2Request(authorizationRequest);
        OAuth2Authentication oAuth2Authentication = new OAuth2Authentication(oAuth2Request, authentication);
        OAuth2AccessToken oAuth2AccessToken = this.tokenServices.createAccessToken(oAuth2Authentication);
        session.setAttribute("access_token", (Object)oAuth2AccessToken.getValue());
    }

    @Override
    public int getOrder() {
        return 1;
    }
}

