/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import com.hand.hap.account.dto.User;
import com.hand.hap.account.service.IRole;
import com.hand.hap.account.service.IRoleService;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.hr.service.IEmployeeAssignService;
import com.hand.hap.security.CustomUserDetails;
import com.hand.hap.system.dto.SysPreferences;
import com.hand.hap.system.service.ISysPreferencesService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.util.StringUtils;

public class CustomJwtAccessTokenConverter
extends JwtAccessTokenConverter {
    @Autowired
    @Qualifier(value="roleServiceImpl")
    private IRoleService roleService;
    @Autowired
    IUserService userService;
    @Autowired
    ISysPreferencesService preferencesService;
    @Autowired
    IEmployeeAssignService employeeAssignService;

    public OAuth2AccessToken enhance(OAuth2AccessToken accessToken, OAuth2Authentication authentication) {
        DefaultOAuth2AccessToken result = (DefaultOAuth2AccessToken)super.enhance(accessToken, authentication);
        if (authentication.getUserAuthentication() != null && authentication.getUserAuthentication().getPrincipal() instanceof CustomUserDetails) {
            CustomUserDetails cud = (CustomUserDetails)authentication.getUserAuthentication().getPrincipal();
            Map additionalInformation = result.getAdditionalInformation();
            User user = this.userService.convertToUser(cud);
            this.setUserInfo(additionalInformation, user);
            this.setRoleInfo(additionalInformation, user);
            String encoded = super.encode((OAuth2AccessToken)result, authentication);
            result.setValue(encoded);
        }
        return result;
    }

    public OAuth2Authentication extractAuthentication(Map<String, ?> map) {
        OAuth2Authentication oAuth2Authentication = super.extractAuthentication(map);
        OAuth2Request originRequest = oAuth2Authentication.getOAuth2Request();
        OAuth2Request request = new OAuth2Request(originRequest.getRequestParameters(), originRequest.getClientId(), originRequest.getAuthorities(), true, originRequest.getScope(), originRequest.getResourceIds(), null, null, map);
        return new OAuth2Authentication(request, oAuth2Authentication.getUserAuthentication());
    }

    private void setUserInfo(Map<String, Object> additionalInformation, User user) {
        SysPreferences pref;
        Long companyId;
        additionalInformation.put("userId", user.getUserId());
        additionalInformation.put("employeeCode", user.getEmployeeCode());
        if (user.getEmployeeId() != null && (companyId = this.employeeAssignService.getCompanyByEmployeeId(user.getEmployeeId())) != null) {
            additionalInformation.put("companyId", companyId);
        }
        if ((pref = this.preferencesService.selectUserPreference("locale", user.getUserId())) != null) {
            additionalInformation.put("locale", StringUtils.parseLocaleString((String)pref.getPreferencesValue()));
        }
    }

    private void setRoleInfo(Map<String, Object> additionalInformation, User user) {
        List<IRole> roles = this.roleService.selectActiveRolesByUser(RequestHelper.newEmptyRequest(), user);
        if (!roles.isEmpty()) {
            ArrayList roleIds = new ArrayList();
            roles.forEach(t -> roleIds.add(t.getRoleId()));
            additionalInformation.put("roleIds", roleIds);
        }
    }
}

