/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import com.hand.hap.account.dto.User;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.security.CheckUserUtil;
import com.hand.hap.security.CustomUserDetails;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class CustomAuthenticationUserDetailsService
implements AuthenticationUserDetailsService {
    @Autowired
    private IUserService userService;
    Logger logger = LoggerFactory.getLogger(CustomAuthenticationUserDetailsService.class);

    public UserDetails loadUserDetails(Authentication authentication) throws UsernameNotFoundException {
        this.logger.debug("===========================================================");
        this.logger.debug(authentication.getPrincipal().toString());
        User user = this.userService.selectByUserName(authentication.getPrincipal().toString());
        if (user == null) {
            throw new UsernameNotFoundException("User not found:" + authentication.getPrincipal().toString());
        }
        CheckUserUtil.checkUserException(user);
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority("ROLE_USER"));
        for (String role : user.getRoleCode()) {
            authorities.add(new SimpleGrantedAuthority(role));
        }
        CustomUserDetails userDetails = new CustomUserDetails(user.getUserId(), user.getUserName(), user.getPasswordEncrypted(), true, true, true, true, authorities, user.getEmployeeId(), user.getEmployeeCode());
        return userDetails;
    }
}

