/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import com.hand.hap.account.exception.UserException;
import com.hand.hap.core.components.CaptchaConfig;
import com.hand.hap.security.captcha.ICaptchaManager;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.WebUtils;

public class CaptchaVerifierFilter
extends OncePerRequestFilter {
    @Autowired
    private ICaptchaManager captchaManager;
    @Autowired
    private CaptchaConfig captchaConfig;
    private RequestMatcher loginRequestMatcher;
    private String captchaField = "captcha";
    private String loginUrl = "/login";

    public CaptchaVerifierFilter() {
        this.setFilterProcessesUrl(this.loginUrl);
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.captchaConfig.isEnableCaptcha(WebUtils.getCookie((HttpServletRequest)httpServletRequest, (String)"loginKey")) && this.requiresValidateCaptcha(httpServletRequest, httpServletResponse)) {
            Cookie cookie = WebUtils.getCookie((HttpServletRequest)httpServletRequest, (String)this.captchaManager.getCaptchaKeyName());
            String captchaCode = httpServletRequest.getParameter(this.getCaptchaField());
            if (cookie == null || StringUtils.isEmpty((String)captchaCode) || !this.captchaManager.checkCaptcha(cookie.getValue(), captchaCode)) {
                httpServletRequest.setAttribute("error", (Object)true);
                httpServletRequest.setAttribute("code", (Object)"CAPTCHA_INVALID");
                httpServletRequest.setAttribute("exception", (Object)new UserException("error.login.verification_code_error", null));
                httpServletRequest.getRequestDispatcher(this.loginUrl).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public String getCaptchaField() {
        return this.captchaField;
    }

    public void setCaptchaField(String captchaField) {
        this.captchaField = captchaField;
    }

    public void setFilterProcessesUrl(String filterProcessesUrl) {
        this.loginRequestMatcher = new AntPathRequestMatcher(filterProcessesUrl);
    }

    protected boolean requiresValidateCaptcha(HttpServletRequest request, HttpServletResponse response) {
        return this.loginRequestMatcher.matches(request) && "POST".equalsIgnoreCase(request.getMethod());
    }
}

