/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mybatis.mapperhelper;

import com.hand.hap.mybatis.annotation.Condition;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.mybatis.common.query.Comparison;
import com.hand.hap.mybatis.common.query.JoinColumn;
import com.hand.hap.mybatis.common.query.JoinOn;
import com.hand.hap.mybatis.common.query.JoinTable;
import com.hand.hap.mybatis.common.query.Selection;
import com.hand.hap.mybatis.common.query.SortField;
import com.hand.hap.mybatis.common.query.Where;
import com.hand.hap.mybatis.common.query.WhereField;
import com.hand.hap.mybatis.entity.EntityColumn;
import com.hand.hap.mybatis.entity.EntityField;
import com.hand.hap.mybatis.entity.EntityTable;
import com.hand.hap.mybatis.entity.IDynamicTableName;
import com.hand.hap.mybatis.mapperhelper.EntityHelper;
import com.hand.hap.mybatis.util.StringUtil;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.hap.system.dto.DTOClassInfo;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Table;
import javax.persistence.criteria.JoinType;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlHelper {
    private static Logger logger = LoggerFactory.getLogger(SqlHelper.class);

    public static String getDynamicTableName(Class<?> entityClass, String tableName) {
        if (IDynamicTableName.class.isAssignableFrom(entityClass)) {
            return "<if test=\"@com.hand.hap.mybatis.util.OGNL@isDynamicParameter(_parameter) and dynamicTableName != null and dynamicTableName != ''\">\n${dynamicTableName}\n</if>\n<if test=\"@com.hand.hap.mybatis.util.OGNL@isNotDynamicParameter(_parameter) or dynamicTableName == null or dynamicTableName == ''\">\n" + tableName + "\n</if>";
        }
        return tableName;
    }

    public static String getDynamicTableName(Class<?> entityClass, String tableName, String parameterName) {
        if (IDynamicTableName.class.isAssignableFrom(entityClass)) {
            if (StringUtil.isNotEmpty(parameterName)) {
                return "<if test=\"@com.hand.hap.mybatis.util.OGNL@isDynamicParameter(" + parameterName + ") and " + parameterName + ".dynamicTableName != null and " + parameterName + ".dynamicTableName != ''\">\n${" + parameterName + ".dynamicTableName}\n</if>\n<if test=\"@com.hand.hap.mybatis.util.OGNL@isNotDynamicParameter(" + parameterName + ") or " + parameterName + ".dynamicTableName == null or " + parameterName + ".dynamicTableName == ''\">\n" + tableName + "\n</if>";
            }
            return SqlHelper.getDynamicTableName(entityClass, tableName);
        }
        return tableName;
    }

    public static String getBindCache(EntityColumn column) {
        StringBuilder sql = new StringBuilder();
        sql.append("<bind name=\"");
        sql.append(column.getProperty()).append("_cache\" ");
        sql.append("value=\"").append(column.getProperty()).append("\"/>");
        return sql.toString();
    }

    public static String getBindValue(EntityColumn column, String value) {
        StringBuilder sql = new StringBuilder();
        sql.append("<bind name=\"");
        sql.append(column.getProperty()).append("_bind\" ");
        sql.append("value='").append(value).append("'/>");
        return sql.toString();
    }

    public static String getIfCacheNotNull(EntityColumn column, String contents) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"").append(column.getProperty()).append("_cache != null\">");
        sql.append(contents);
        sql.append("</if>");
        return sql.toString();
    }

    public static String getIfCacheIsNull(EntityColumn column, String contents) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"").append(column.getProperty()).append("_cache == null\">");
        sql.append(contents);
        sql.append("</if>");
        return sql.toString();
    }

    public static String getIfNotNull(EntityColumn column, String contents, boolean empty) {
        return SqlHelper.getIfNotNull(null, column, contents, empty);
    }

    public static String getIfIsNull(EntityColumn column, String contents, boolean empty) {
        return SqlHelper.getIfIsNull(null, column, contents, empty);
    }

    public static String getIfNotNull(String entityName, EntityColumn column, String contents, boolean empty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"");
        if (StringUtil.isNotEmpty(entityName)) {
            sql.append(entityName).append(".");
        }
        sql.append(column.getProperty()).append(" != null");
        if (empty && column.getJavaType().equals(String.class)) {
            sql.append(" and ");
            if (StringUtil.isNotEmpty(entityName)) {
                sql.append(entityName).append(".");
            }
            sql.append(column.getProperty()).append(" != '' ");
        }
        sql.append("\">");
        sql.append(contents);
        sql.append("</if>");
        return sql.toString();
    }

    public static String getIfNotNullWithOptions(EntityColumn column, String contents) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"");
        sql.append("null== criteria || null == criteria.updateFields || criteria.updateFields.isEmpty() || ");
        sql.append("criteria.updateFields").append(".contains('");
        sql.append(column.getProperty()).append("')");
        sql.append("\">");
        sql.append(contents);
        sql.append("</if>");
        return sql.toString();
    }

    public static String getIfIsNull(String entityName, EntityColumn column, String contents, boolean empty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"");
        if (StringUtil.isNotEmpty(entityName)) {
            sql.append(entityName).append(".");
        }
        sql.append(column.getProperty()).append(" == null");
        if (empty && column.getJavaType().equals(String.class)) {
            sql.append(" or ");
            if (StringUtil.isNotEmpty(entityName)) {
                sql.append(entityName).append(".");
            }
            sql.append(column.getProperty()).append(" == '' ");
        }
        sql.append("\">");
        sql.append(contents);
        sql.append("</if>");
        return sql.toString();
    }

    public static String getAllColumns(Class<?> entityClass) {
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        StringBuilder sql = new StringBuilder();
        for (EntityColumn entityColumn : columnList) {
            sql.append(entityColumn.getColumn()).append(",");
        }
        return sql.substring(0, sql.length() - 1);
    }

    public static String selectAllColumns(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(SqlHelper.getAllColumns(entityClass));
        sql.append(" ");
        return sql.toString();
    }

    public static String getAllColumns_TL(Class<?> entityClass) {
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        StringBuilder sql = new StringBuilder();
        EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        for (EntityColumn entityColumn : columnList) {
            if (entityTable.isSupportMultiLanguage()) {
                sql.append(entityColumn.isMultiLanguageField() ? "t." : "b.");
            }
            sql.append(entityColumn.getColumn()).append(",");
        }
        return sql.substring(0, sql.length() - 1);
    }

    public static String selectAllColumns_TL(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(SqlHelper.getAllColumns_TL(entityClass));
        sql.append(" ");
        return sql.toString();
    }

    public static String selectCount(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        Set<EntityColumn> pkColumns = EntityHelper.getPKColumns(entityClass);
        if (pkColumns.size() == 1) {
            sql.append("COUNT(").append(pkColumns.iterator().next().getColumn()).append(") ");
        } else {
            sql.append("COUNT(*) ");
        }
        return sql.toString();
    }

    public static String fromTable(Class<?> entityClass, String defaultTableName) {
        StringBuilder sql = new StringBuilder();
        sql.append(" FROM ");
        sql.append(SqlHelper.getDynamicTableName(entityClass, defaultTableName));
        sql.append(" ");
        return sql.toString();
    }

    public static String fromTable_TL(Class<?> entityClass, String defaultTableName) {
        StringBuilder sql = new StringBuilder();
        sql.append(" FROM ");
        String tableName = entityClass.getAnnotation(Table.class).name();
        EntityField[] ids = DTOClassInfo.getIdFields(entityClass);
        sql.append(tableName).append(" b ");
        if (tableName.toUpperCase().endsWith("_B")) {
            sql.append("LEFT OUTER JOIN ").append(tableName.substring(0, tableName.length() - 2) + "_TL t ");
        } else {
            sql.append("LEFT OUTER JOIN ").append(tableName + "_TL t ");
        }
        sql.append("ON (");
        for (EntityField f : ids) {
            String columnName = DTOClassInfo.getColumnName(f);
            sql.append("b.").append(columnName).append("=t.").append(columnName).append(" AND ");
        }
        sql.append("t.LANG=#{request.locale,jdbcType=VARCHAR,javaType=java.lang.String}");
        sql.append(")");
        sql.append(" ");
        return sql.toString();
    }

    public static String updateTable(Class<?> entityClass, String defaultTableName) {
        return SqlHelper.updateTable(entityClass, defaultTableName, null);
    }

    public static String updateTable(Class<?> entityClass, String defaultTableName, String entityName) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(SqlHelper.getDynamicTableName(entityClass, defaultTableName, entityName));
        sql.append(" ");
        return sql.toString();
    }

    public static String deleteFromTable(Class<?> entityClass, String defaultTableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(SqlHelper.getDynamicTableName(entityClass, defaultTableName));
        sql.append(" ");
        return sql.toString();
    }

    public static String insertIntoTable(Class<?> entityClass, String defaultTableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(SqlHelper.getDynamicTableName(entityClass, defaultTableName));
        sql.append(" ");
        return sql.toString();
    }

    public static String insertColumns(Class<?> entityClass, boolean skipId, boolean notNull, boolean notEmpty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        for (EntityColumn column : columnList) {
            if (!column.isInsertable() || skipId && column.isId()) continue;
            if (notNull) {
                sql.append(SqlHelper.getIfNotNull(column, column.getColumn() + ",", notEmpty));
                continue;
            }
            sql.append(column.getColumn() + ",");
        }
        sql.append("</trim>");
        return sql.toString();
    }

    public static String insertValuesColumns(Class<?> entityClass, boolean skipId, boolean notNull, boolean notEmpty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<trim prefix=\"VALUES (\" suffix=\")\" suffixOverrides=\",\">");
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        for (EntityColumn column : columnList) {
            if (!column.isInsertable() || skipId && column.isId()) continue;
            if (notNull) {
                sql.append(SqlHelper.getIfNotNull(column, column.getColumnHolder() + ",", notEmpty));
                continue;
            }
            sql.append(column.getColumnHolder() + ",");
        }
        sql.append("</trim>");
        return sql.toString();
    }

    public static String updateSetColumns(Class<?> entityClass, String entityName, boolean notNull, boolean notEmpty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<set>");
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        for (EntityColumn column : columnList) {
            if (!column.isId() && column.isUpdatable()) {
                if ("last_update_date".equalsIgnoreCase(column.getColumn())) {
                    sql.append(column.getColumn()).append("=").append("CURRENT_TIMESTAMP,");
                    continue;
                }
                if (notNull) {
                    sql.append(SqlHelper.getIfNotNull(entityName, column, column.getColumnEqualsHolder(entityName) + ",", notEmpty));
                    continue;
                }
                sql.append(column.getColumnEqualsHolder(entityName) + ",");
                continue;
            }
            if (!"object_version_number".equalsIgnoreCase(column.getColumn())) continue;
            sql.append(column.getColumn()).append("=").append(column.getColumn()).append("+1,");
        }
        sql.append("</set>");
        return sql.toString();
    }

    public static String updateSetColumnsWithOption(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<set>");
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        for (EntityColumn column : columnList) {
            if (!column.isId() && column.isUpdatable()) {
                if ("last_update_date".equalsIgnoreCase(column.getColumn())) {
                    sql.append(column.getColumn()).append("=").append("CURRENT_TIMESTAMP,");
                    continue;
                }
                sql.append(SqlHelper.getIfNotNullWithOptions(column, column.getColumnEqualsHolder("dto") + ","));
                continue;
            }
            if (!"object_version_number".equalsIgnoreCase(column.getColumn())) continue;
            sql.append(column.getColumn()).append("=").append(column.getColumn()).append("+1,");
        }
        sql.append("</set>");
        return sql.toString();
    }

    public static String wherePKColumns(Class<?> entityClass) {
        return SqlHelper.wherePKColumns(entityClass, null);
    }

    public static String wherePKColumns(Class<?> entityClass, String entityName) {
        StringBuilder sql = new StringBuilder();
        sql.append("<where>");
        Set<EntityColumn> columnList = EntityHelper.getPKColumns(entityClass);
        for (EntityColumn column : columnList) {
            sql.append(" AND " + column.getColumnEqualsHolder(entityName));
        }
        sql.append("</where>");
        return sql.toString();
    }

    public static String wherePKColumns_TL(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<where>");
        Set<EntityColumn> columnList = EntityHelper.getPKColumns(entityClass);
        for (EntityColumn column : columnList) {
            sql.append(" AND b." + column.getColumnEqualsHolder());
        }
        sql.append("</where>");
        return sql.toString();
    }

    public static String whereAllIfColumns(Class<?> entityClass, boolean empty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<where>");
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        for (EntityColumn column : columnList) {
            Condition condition = column.getCondition();
            if (condition == null) {
                sql.append(SqlHelper.getIfNotNull(column, " AND " + column.getColumnEqualsHolder(), empty));
                continue;
            }
            if (condition.exclude()) continue;
            sql.append(SqlHelper.getIfNotNull(column, " AND " + column.getColumnHolderWithOperator(condition.operator(), condition.autoWrap()), empty));
        }
        sql.append("</where>");
        return sql.toString();
    }

    public static String whereAllIfColumns_TL(Class<?> entityClass, boolean empty, boolean equals) {
        StringBuilder sql = new StringBuilder();
        sql.append("<where>");
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        for (EntityColumn column : columnList) {
            if (column.isMultiLanguageField()) {
                sql.append(SqlHelper.getIfNotNull(column, " AND t." + (equals ? column.getColumnEqualsHolder() : column.getColumnLikeHolder()), empty));
                continue;
            }
            Condition condition = column.getCondition();
            if (condition == null) {
                sql.append(SqlHelper.getIfNotNull(column, " AND b." + column.getColumnEqualsHolder(), empty));
                continue;
            }
            if (condition.exclude()) continue;
            sql.append(SqlHelper.getIfNotNull(column, " AND b." + column.getColumnHolderWithOperator(condition.operator(), condition.autoWrap()), empty));
        }
        sql.append("</where>");
        return sql.toString();
    }

    public static String orderByDefault(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        if (BaseDTO.class.isAssignableFrom(entityClass)) {
            sql.append("<bind name=\"__orderByClause\" value=\"@com.hand.hap.mybatis.util.OGNL@getOrderByClause(_parameter)\"/>");
            sql.append("<if test=\"__orderByClause!=null\">");
            sql.append("ORDER BY ${__orderByClause}");
            sql.append("</if>");
        } else {
            EntityField[] idField = DTOClassInfo.getIdFields(entityClass);
            if (idField.length > 0) {
                sql.append("ORDER BY ").append(DTOClassInfo.getColumnName(idField[0])).append(" ASC");
            }
        }
        return sql.toString();
    }

    public static String orderByDefault_TL(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        if (BaseDTO.class.isAssignableFrom(entityClass)) {
            sql.append("<bind name=\"__orderByClause\" value=\"@com.hand.hap.mybatis.util.OGNL@getOrderByClause_TL(_parameter)\"/>");
            sql.append("<if test=\"__orderByClause!=null\">");
            sql.append("ORDER BY ${__orderByClause}");
            sql.append("</if>");
        } else {
            EntityField[] idField = DTOClassInfo.getIdFields(entityClass);
            if (idField.length > 0) {
                sql.append("ORDER BY b.").append(DTOClassInfo.getColumnName(idField[0])).append(" ASC");
            }
        }
        return sql.toString();
    }

    public static String exampleSelectColumns(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"@com.hand.hap.mybatis.util.OGNL@hasSelectColumns(_parameter)\">");
        sql.append("<foreach collection=\"_parameter.selectColumns\" item=\"selectColumn\" separator=\",\">");
        sql.append("${selectColumn}");
        sql.append("</foreach>");
        sql.append("</if>");
        sql.append("<if test=\"@com.hand.hap.mybatis.util.OGNL@hasNoSelectColumns(_parameter)\">");
        sql.append(SqlHelper.getAllColumns(entityClass));
        sql.append("</if>");
        return sql.toString();
    }

    public static String exampleOrderBy(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"orderByClause != null\">");
        sql.append("order by ${orderByClause}");
        sql.append("</if>");
        String orderByClause = EntityHelper.getOrderByClause(entityClass);
        if (orderByClause.length() > 0) {
            sql.append("<if test=\"orderByClause == null\">");
            sql.append("ORDER BY " + orderByClause);
            sql.append("</if>");
        }
        return sql.toString();
    }

    public static String exampleWhereClause() {
        return "<if test=\"_parameter != null\"><where>\n  <foreach collection=\"oredCriteria\" item=\"criteria\" separator=\"or\">\n    <if test=\"criteria.valid\">\n      <trim prefix=\"(\" prefixOverrides=\"and\" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n            <when test=\"criterion.noValue\">\n              and ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              and ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              and ${criterion.condition} #{criterion.value} and #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              and ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\" open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where></if>";
    }

    public static String updateByExampleWhereClause() {
        return "<where>\n  <foreach collection=\"example.oredCriteria\" item=\"criteria\" separator=\"or\">\n    <if test=\"criteria.valid\">\n      <trim prefix=\"(\" prefixOverrides=\"and\" suffix=\")\">\n        <foreach collection=\"criteria.criteria\" item=\"criterion\">\n          <choose>\n            <when test=\"criterion.noValue\">\n              and ${criterion.condition}\n            </when>\n            <when test=\"criterion.singleValue\">\n              and ${criterion.condition} #{criterion.value}\n            </when>\n            <when test=\"criterion.betweenValue\">\n              and ${criterion.condition} #{criterion.value} and #{criterion.secondValue}\n            </when>\n            <when test=\"criterion.listValue\">\n              and ${criterion.condition}\n              <foreach close=\")\" collection=\"criterion.value\" item=\"listItem\" open=\"(\" separator=\",\">\n                #{listItem}\n              </foreach>\n            </when>\n          </choose>\n        </foreach>\n      </trim>\n    </if>\n  </foreach>\n</where>";
    }

    public static String buildSelectByPrimaryKeySQL(BaseDTO dto) {
        EntityTable table = EntityHelper.getEntityTable(dto.getClass());
        Criteria criteria = new Criteria();
        for (EntityColumn pkColumn : table.getEntityClassPKColumns()) {
            criteria.where(pkColumn.getProperty());
        }
        return SqlHelper.buildSelectSelectiveSql(dto, criteria);
    }

    public static String buildSelectSelectiveSql(final BaseDTO dto, final Criteria criteria) {
        final EntityTable table = EntityHelper.getEntityTable(dto.getClass());
        final ArrayList<Selection> selectFields = new ArrayList<Selection>(50);
        List<Selection> selections = criteria.getSelectFields();
        if (selections == null || selections.isEmpty()) {
            for (EntityColumn column : table.getAllColumns()) {
                if (criteria.getExcludeSelectFields() != null && criteria.getExcludeSelectFields().contains(column.getProperty())) continue;
                selectFields.add(new Selection(column.getProperty()));
            }
        } else {
            for (Selection selection : selections) {
                if (criteria.getExcludeSelectFields() != null && criteria.getExcludeSelectFields().contains(selection.getField())) continue;
                selectFields.add(selection);
            }
        }
        String sql = ((StringBuilder)new SQL(){
            {
                block12: {
                    block13: {
                        block11: {
                            List<SortField> list2;
                            for (Selection selection : selectFields) {
                                String selectionSql = SqlHelper.generateSelectionSQL(dto, selection);
                                if (!StringUtils.isNotEmpty((String)selectionSql)) continue;
                                this.SELECT(selectionSql);
                            }
                            this.FROM(table.getName() + " " + table.getAlias());
                            for (Map.Entry entry : table.getJoinMapping().entrySet()) {
                                JoinTable jt;
                                EntityColumn column = (EntityColumn)entry.getValue();
                                String joinSql = SqlHelper.generateJoinSQL(dto, column, jt = column.findJoinTableByName((String)entry.getKey()), selectFields);
                                if (!StringUtils.isNotBlank((String)joinSql)) continue;
                                JoinType joinType = jt.type();
                                switch (joinType) {
                                    case LEFT: {
                                        this.LEFT_OUTER_JOIN(joinSql);
                                        break;
                                    }
                                    case INNER: {
                                        this.INNER_JOIN(joinSql);
                                        break;
                                    }
                                    case RIGHT: {
                                        this.RIGHT_OUTER_JOIN(joinSql);
                                    }
                                }
                            }
                            String whereSql = SqlHelper.generateWhereClauseSQL(dto, criteria);
                            if (StringUtils.isNotBlank((String)whereSql)) {
                                this.WHERE(whereSql);
                            }
                            if ((list2 = criteria.getSortFields()) == null || list2.isEmpty()) break block11;
                            block7: for (SortField sortField : list2) {
                                for (EntityColumn sortColumn : table.getSortColumns()) {
                                    if (!sortColumn.getProperty().equals(sortField.getField())) continue;
                                    this.ORDER_BY(SqlHelper.findColumnNameByField(dto, sortField.getField(), false) + sortField.getSortType().sql());
                                    continue block7;
                                }
                            }
                            break block12;
                        }
                        if (!CollectionUtils.isEmpty(table.getSortColumns())) break block13;
                        EntityField[] idField = DTOClassInfo.getIdFields(dto.getClass());
                        if (idField.length <= 0) break block12;
                        this.ORDER_BY(DTOClassInfo.getColumnName(idField[0]) + " ASC");
                        break block12;
                    }
                    for (EntityColumn sortColumn : table.getSortColumns()) {
                        if (sortColumn.getOrderBy() == null) continue;
                        this.ORDER_BY(SqlHelper.findColumnNameByField(dto, sortColumn, false) + " " + sortColumn.getOrderBy());
                    }
                }
            }
        }.usingAppender((Appendable)new StringBuilder())).toString();
        return sql;
    }

    private static String generateSelectionSQL(BaseDTO dto, Selection selection) {
        return SqlHelper.findColumnNameByField(dto, selection.getField(), true);
    }

    private static String findColumnNameByField(BaseDTO dto, String field, boolean withAlias) {
        EntityTable table = EntityHelper.getEntityTable(dto.getClass());
        EntityColumn entityColumn = table.findColumnByProperty(field);
        return SqlHelper.findColumnNameByField(dto, entityColumn, withAlias);
    }

    private static String findColumnNameByField(BaseDTO dto, EntityColumn entityColumn, boolean withAlias) {
        EntityTable table = EntityHelper.getEntityTable(dto.getClass());
        StringBuilder sb = new StringBuilder();
        if (entityColumn != null) {
            JoinColumn jc = entityColumn.getJoinColumn();
            if (jc != null) {
                EntityColumn joinField = table.getJoinMapping().get(jc.joinName());
                JoinTable joinTable = joinField.findJoinTableByName(jc.joinName());
                if (joinField != null && joinTable != null) {
                    EntityTable joinEntityTable = EntityHelper.getEntityTable(joinTable.target());
                    EntityColumn refColumn = joinEntityTable.findColumnByProperty(jc.field());
                    sb.append(table.getAlias(EntityHelper.buildJoinKey(joinTable))).append(".").append(refColumn.getColumn());
                    if (withAlias) {
                        sb.append(" AS ").append(entityColumn.getColumn());
                    }
                }
            } else {
                sb.append(table.getAlias()).append(".").append(entityColumn.getColumn());
            }
        }
        return sb.toString();
    }

    private static String generateJoinSQL(BaseDTO dto, EntityColumn localColumn, JoinTable joinTable, List<Selection> selections) {
        StringBuilder sb = new StringBuilder();
        EntityTable localTable = EntityHelper.getEntityTable(dto.getClass());
        String joinKey = EntityHelper.buildJoinKey(joinTable);
        EntityTable foreignTable = EntityHelper.getEntityTable(joinTable.target());
        boolean foundJoinColumn = false;
        for (Selection selection : selections) {
            EntityColumn entityColumn = localTable.findColumnByProperty(selection.getField());
            if (entityColumn == null || entityColumn.getJoinColumn() == null || !joinTable.name().equals(entityColumn.getJoinColumn().joinName())) continue;
            foundJoinColumn = true;
            break;
        }
        if (foundJoinColumn) {
            String jointTableName = foreignTable.getName();
            if (joinTable.joinMultiLanguageTable()) {
                jointTableName = jointTableName.toUpperCase().endsWith("_B") ? jointTableName.substring(0, jointTableName.length() - 2) + "_TL" : jointTableName + "_TL";
            }
            sb.append(jointTableName).append(" ").append(localTable.getAlias(joinKey)).append(" ON ");
            JoinOn[] joinOns = joinTable.on();
            int j = joinOns.length;
            for (int i = 0; i < j; ++i) {
                EntityColumn foreignColumn;
                String columnName;
                JoinOn joinOn = joinOns[i];
                String joinField = joinOn.joinField();
                if (StringUtils.isEmpty((String)joinField)) continue;
                if (i != 0) {
                    sb.append(" AND ");
                }
                String string = columnName = (foreignColumn = foreignTable.findColumnByProperty(joinField)) != null ? foreignColumn.getColumn() : StringUtil.camelhumpToUnderline(joinField);
                if (StringUtils.isEmpty((String)joinOn.joinExpression())) {
                    sb.append(localTable.getAlias()).append(".").append(localColumn.getColumn()).append(" = ");
                    sb.append(localTable.getAlias(joinKey)).append(".").append(columnName);
                    continue;
                }
                sb.append(localTable.getAlias(joinKey)).append(".").append(columnName);
                sb.append(" = ").append(joinOn.joinExpression());
            }
        }
        return sb.toString();
    }

    private static String generateWhereClauseSQL(BaseDTO dto, Criteria criteria) {
        StringBuilder sb = new StringBuilder();
        List<WhereField> whereFields = criteria.getWhereFields();
        EntityTable table = EntityHelper.getEntityTable(dto.getClass());
        for (EntityColumn column : table.getWhereColumns()) {
            try {
                if (BeanUtils.getProperty((Object)dto, (String)column.getProperty()) == null) continue;
                Where where = column.getWhere();
                Comparison comparison = where.comparison();
                boolean isWhereField = false;
                if (whereFields != null && !whereFields.isEmpty()) {
                    for (WhereField whereField : whereFields) {
                        String f = whereField.getField();
                        if (f == null || !f.equals(column.getProperty())) continue;
                        isWhereField = true;
                        if (whereField.getComparison() == null) break;
                        comparison = whereField.getComparison();
                        break;
                    }
                    if (!isWhereField) continue;
                }
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                String columnName = column.getColumn();
                JoinColumn jc = column.getJoinColumn();
                if (jc != null) {
                    EntityColumn joinField = table.getJoinMapping().get(jc.joinName());
                    JoinTable jt = joinField.findJoinTableByName(jc.joinName());
                    EntityTable foreignTable = EntityHelper.getEntityTable(jt.target());
                    EntityColumn foreignColumn = foreignTable.findColumnByProperty(jc.field());
                    columnName = foreignColumn.getColumn();
                    sb.append(table.getAlias(EntityHelper.buildJoinKey(jt))).append(".");
                } else {
                    sb.append(table.getAlias()).append(".");
                }
                sb.append(columnName).append(SqlHelper.formatComparisonSQL(comparison.sql(), column.getColumnHolder("dto")));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return sb.toString();
    }

    private static String formatComparisonSQL(String format, String placeHolder) {
        if (format.indexOf("{0}") != -1) {
            MessageFormat mf = new MessageFormat(format);
            return mf.format(new String[]{placeHolder});
        }
        return format + placeHolder;
    }
}

