/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mybatis.entity;

import com.hand.hap.mybatis.entity.EntityColumn;
import com.hand.hap.mybatis.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Table;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;

public class EntityTable {
    private static final char ALIAS_START = 'A';
    private int currentAliasCharIndex = 0;
    private String name;
    private String catalog;
    private String schema;
    private String orderByClause;
    private String baseSelect;
    private Set<EntityColumn> allColumns = new LinkedHashSet<EntityColumn>();
    private Set<EntityColumn> entityClassColumns;
    private Set<EntityColumn> entityClassPKColumns;
    private List<String> keyProperties;
    private List<String> keyColumns;
    private ResultMap resultMap;
    private Class<?> entityClass;
    private Set<EntityColumn> sortColumns = new LinkedHashSet<EntityColumn>();
    private Map<String, String> aliasMapping = new HashMap<String, String>();
    private Map<String, EntityColumn> joinMapping = new HashMap<String, EntityColumn>();
    private List<EntityColumn> whereColumns = new ArrayList<EntityColumn>();
    private boolean supportMultiLanguage = false;

    public EntityTable(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.createAlias(entityClass.getCanonicalName());
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setTable(Table table) {
        this.name = table.name();
        this.catalog = table.catalog();
        this.schema = table.schema();
    }

    public void setKeyColumns(List<String> keyColumns) {
        this.keyColumns = keyColumns;
    }

    public void setKeyProperties(List<String> keyProperties) {
        this.keyProperties = keyProperties;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getBaseSelect() {
        return this.baseSelect;
    }

    public void setBaseSelect(String baseSelect) {
        this.baseSelect = baseSelect;
    }

    public String getPrefix() {
        if (StringUtil.isNotEmpty(this.catalog)) {
            return this.catalog;
        }
        if (StringUtil.isNotEmpty(this.schema)) {
            return this.schema;
        }
        return "";
    }

    public Set<EntityColumn> getEntityClassColumns() {
        return this.entityClassColumns;
    }

    public void setEntityClassColumns(Set<EntityColumn> entityClassColumns) {
        this.entityClassColumns = entityClassColumns;
    }

    public Set<EntityColumn> getEntityClassPKColumns() {
        return this.entityClassPKColumns;
    }

    public void setEntityClassPKColumns(Set<EntityColumn> entityClassPKColumns) {
        this.entityClassPKColumns = entityClassPKColumns;
    }

    public String[] getKeyProperties() {
        if (this.keyProperties != null && !this.keyProperties.isEmpty()) {
            return this.keyProperties.toArray(new String[0]);
        }
        return new String[0];
    }

    public void setKeyProperties(String keyProperty) {
        if (this.keyProperties == null) {
            this.keyProperties = new ArrayList<String>();
            this.keyProperties.add(keyProperty);
        } else {
            this.keyProperties.add(keyProperty);
        }
    }

    public String[] getKeyColumns() {
        if (this.keyColumns != null && !this.keyColumns.isEmpty()) {
            return this.keyColumns.toArray(new String[0]);
        }
        return new String[0];
    }

    public void setKeyColumns(String keyColumn) {
        if (this.keyColumns == null) {
            this.keyColumns = new ArrayList<String>();
            this.keyColumns.add(keyColumn);
        } else {
            this.keyColumns.add(keyColumn);
        }
    }

    public boolean isSupportMultiLanguage() {
        return this.supportMultiLanguage;
    }

    public void setSupportMultiLanguage(boolean supportMultiLanguage) {
        this.supportMultiLanguage = supportMultiLanguage;
    }

    public ResultMap getResultMap(Configuration configuration) {
        if (this.resultMap != null) {
            return this.resultMap;
        }
        if (this.allColumns == null || this.allColumns.isEmpty()) {
            return null;
        }
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        for (EntityColumn entityColumn : this.allColumns) {
            ResultMapping.Builder builder = new ResultMapping.Builder(configuration, entityColumn.getProperty(), entityColumn.getColumn(), entityColumn.getJavaType());
            if (entityColumn.getJdbcType() != null) {
                builder.jdbcType(entityColumn.getJdbcType());
            }
            if (entityColumn.getTypeHandler() != null) {
                try {
                    builder.typeHandler(entityColumn.getTypeHandler().newInstance());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            if (entityColumn.isId()) {
                flags.add(ResultFlag.ID);
            }
            builder.flags(flags);
            resultMappings.add(builder.build());
        }
        ResultMap.Builder builder = new ResultMap.Builder(configuration, "BaseMapperResultMap", this.entityClass, resultMappings, Boolean.valueOf(true));
        this.resultMap = builder.build();
        return this.resultMap;
    }

    public void createAlias(String key) {
        if (!this.aliasMapping.containsKey(key)) {
            this.aliasMapping.put(key, this.generateAlias());
        }
    }

    public String getAlias(String key) {
        return key == null ? this.aliasMapping.get(this.entityClass.getCanonicalName()) : this.aliasMapping.get(key);
    }

    public Map<String, EntityColumn> getJoinMapping() {
        return this.joinMapping;
    }

    public String getAlias() {
        return this.getAlias(null);
    }

    private String generateAlias() {
        return String.valueOf((char)(65 + this.currentAliasCharIndex++));
    }

    public List<EntityColumn> getWhereColumns() {
        return this.whereColumns;
    }

    public Set<EntityColumn> getSortColumns() {
        return this.sortColumns;
    }

    public Set<EntityColumn> getAllColumns() {
        return this.allColumns;
    }

    public EntityColumn findColumnByProperty(String property) {
        EntityColumn entityColumn = null;
        for (EntityColumn column : this.getAllColumns()) {
            if (!column.getProperty().equals(property)) continue;
            entityColumn = column;
            break;
        }
        return entityColumn;
    }
}

