/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message.impl;

import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.message.ITopicMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.data.redis.serializer.RedisSerializer;

public class TopicMessageListener<T>
implements ITopicMessageListener<T>,
BeanNameAware {
    private String[] topic;
    private RedisSerializer<T> redisSerializer;
    private IMessageConsumer<T>[] consumers = new IMessageConsumer[0];
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String[] getTopic() {
        return this.topic;
    }

    public void setTopic(String[] topic) {
        this.topic = topic;
    }

    @Override
    public RedisSerializer<T> getRedisSerializer() {
        return this.redisSerializer;
    }

    public void setRedisSerializer(RedisSerializer<T> redisSerializer) {
        this.redisSerializer = redisSerializer;
    }

    public IMessageConsumer<T>[] getConsumers() {
        return this.consumers;
    }

    public void setConsumers(IMessageConsumer<T>[] consumers) {
        this.consumers = consumers;
    }

    @Override
    public void onTopicMessage(T message, String pattern) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("receive message: {}, pattern: {}, consumers: {}", new Object[]{message, pattern, this.consumers.length});
        }
        for (IMessageConsumer<T> c : this.consumers) {
            try {
                c.onMessage(message, pattern);
            }
            catch (Throwable throwable) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.error("exception occurred while consumer " + c + " handle message:" + message, throwable);
            }
        }
    }

    public void setBeanName(String name) {
        this.setTopic(new String[]{name});
    }
}

