/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message;

import com.hand.hap.task.info.ThreadManageInfo;
import com.hand.hap.task.service.ITaskExecutionService;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class TaskListenerContainer
implements SmartLifecycle {
    private static Logger logger = LoggerFactory.getLogger(TaskListenerContainer.class);
    private static final int PHASE = 99999;
    public static boolean running = false;
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;
    @Autowired
    private ITaskExecutionService taskExecutionService;

    public void start() {
    }

    public int getPhase() {
        return 99999;
    }

    public boolean isAutoStartup() {
        return running;
    }

    public boolean isRunning() {
        running = true;
        return running;
    }

    public void stop(Runnable callback) {
        BlockingQueue<Runnable> taskQueue = this.taskExecutor.getThreadPoolExecutor().getQueue();
        for (Thread thread : taskQueue) {
            taskQueue.remove(thread);
            Long executionId = Long.valueOf(thread.getName().split("-")[1]);
            this.taskExecutionService.updateStatus(executionId, "CANCEL");
            this.taskExecutionService.batchUpdateStatus(executionId, "READY", "UNEXECUTED");
        }
        for (Map.Entry<String, Thread> entry : ThreadManageInfo.threadHashMap.entrySet()) {
            Thread thread = entry.getValue();
            logger.info("{} is shutdown", (Object)entry.getKey());
            Long executionId = Long.valueOf(thread.getName().split("-")[1]);
            this.taskExecutionService.updateStatus(executionId, "CANCEL");
            this.taskExecutionService.batchUpdateStatus(executionId, "SUCCESS", "ROLLBACK");
            this.taskExecutionService.batchUpdateStatus(executionId, "EXECUTING", "CANCEL");
            this.taskExecutionService.batchUpdateStatus(executionId, "READY", "UNEXECUTED");
        }
        if (callback != null) {
            callback.run();
        }
    }

    public void stop() {
    }
}

