/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.ws.interceptor;

import com.hand.hap.intergration.beans.HapinterfaceBound;
import com.hand.hap.intergration.dto.HapInterfaceInbound;
import com.hand.hap.intergration.dto.HapInterfaceOutbound;
import com.hand.hap.intergration.util.HapInvokeLogUtils;
import com.hand.hap.message.IMessagePublisher;
import java.io.OutputStream;
import java.util.Date;
import java.util.logging.Logger;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractLoggingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.Address;
import org.springframework.beans.factory.annotation.Autowired;

@NoJSR250Annotations
public class HapInvokeOutInterceptor
extends AbstractLoggingInterceptor {
    private static final Logger LOG = LogUtils.getLogger(LoggingOutInterceptor.class);
    @Autowired
    private IMessagePublisher messagePublisher;
    public static long DEFAULT_THRESHOLD = 0xA00000L;

    public HapInvokeOutInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(Message message) throws Fault {
        HapInterfaceInbound inbound = (HapInterfaceInbound)message.getExchange().get((Object)"HAP_INBOUND");
        if (inbound != null) {
            this.inboundInvoke(inbound, message);
        } else {
            this.outboundInvoke(message);
        }
    }

    public void handleFault(Message message) {
        HapInvokeLogUtils.processCxfHandleFault(message, this.messagePublisher);
    }

    protected void outboundInvoke(Message message) {
        HapInterfaceOutbound outbound = new HapInterfaceOutbound();
        message.getExchange().put((Object)"HAP_OUTBOUND", (Object)outbound);
        outbound.setRequestTime(new Date());
        Object address = message.get((Object)"http.connection.address");
        String url = address instanceof Address ? ((Address)address).getString() : "";
        outbound.setInterfaceUrl(url);
        Endpoint ep = message.getExchange().getEndpoint();
        EndpointInfo endpoint = ep.getEndpointInfo();
        String serviceName = endpoint.getService().getName().getLocalPart();
        outbound.setInterfaceName(serviceName);
        this.getXmlContent(message);
    }

    protected void inboundInvoke(HapInterfaceInbound inbound, Message message) {
        this.getXmlContent(message);
    }

    protected String getXmlContent(Message message) {
        String content = "";
        try {
            OutputStream os = (OutputStream)message.getContent(OutputStream.class);
            CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(os);
            newOut.setThreshold(DEFAULT_THRESHOLD);
            message.setContent(OutputStream.class, (Object)newOut);
            newOut.registerCallback((CachedOutputStreamCallback)new LoggingCallback(message, os));
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        return content;
    }

    private LoggingMessage setupBuffer(Message message) {
        Object headers;
        String ct;
        String address;
        String httpMethod;
        String encoding;
        String id = (String)message.getExchange().get((Object)LoggingMessage.ID_KEY);
        if (id == null) {
            id = LoggingMessage.nextId();
            message.getExchange().put((Object)LoggingMessage.ID_KEY, (Object)id);
        }
        LoggingMessage buffer = new LoggingMessage("Outbound Message\n---------------------------", id);
        Integer responseCode = (Integer)message.get((Object)Message.RESPONSE_CODE);
        if (responseCode != null) {
            buffer.getResponseCode().append(responseCode);
        }
        if ((encoding = (String)message.get((Object)Message.ENCODING)) != null) {
            buffer.getEncoding().append(encoding);
        }
        if ((httpMethod = (String)message.get((Object)"org.apache.cxf.request.method")) != null) {
            buffer.getHttpMethod().append(httpMethod);
        }
        if ((address = (String)message.get((Object)Message.ENDPOINT_ADDRESS)) != null) {
            buffer.getAddress().append(address);
            String uri = (String)message.get((Object)"org.apache.cxf.request.uri");
            if (uri != null && !address.startsWith(uri)) {
                if (!address.endsWith("/") && !uri.startsWith("/")) {
                    buffer.getAddress().append("/");
                }
                buffer.getAddress().append(uri);
            }
        }
        if ((ct = (String)message.get((Object)"Content-Type")) != null) {
            buffer.getContentType().append(ct);
        }
        if ((headers = message.get((Object)Message.PROTOCOL_HEADERS)) != null) {
            buffer.getHeader().append(headers);
        }
        return buffer;
    }

    protected Logger getLogger() {
        return LOG;
    }

    class LoggingCallback
    implements CachedOutputStreamCallback {
        private final Message message;
        private final OutputStream origStream;

        LoggingCallback(Message msg, OutputStream os) {
            this.message = msg;
            this.origStream = os;
        }

        public void onFlush(CachedOutputStream cos) {
        }

        public void onClose(CachedOutputStream cos) {
            LoggingMessage buffer = HapInvokeOutInterceptor.this.setupBuffer(this.message);
            HapInterfaceOutbound invokeOut = (HapInterfaceOutbound)this.message.getExchange().get((Object)"HAP_OUTBOUND");
            HapInterfaceInbound inbound = (HapInterfaceInbound)this.message.getExchange().get((Object)"HAP_INBOUND");
            String ct = (String)this.message.get((Object)"Content-Type");
            if (!HapInvokeOutInterceptor.this.isShowBinaryContent() && HapInvokeOutInterceptor.this.isBinaryContent(ct)) {
                buffer.getMessage().append("--- Binary Content ---").append('\n');
                return;
            }
            if (!HapInvokeOutInterceptor.this.isShowMultipartContent() && HapInvokeOutInterceptor.this.isMultipartContent(ct)) {
                buffer.getMessage().append("--- Multipart Content ---").append('\n');
                return;
            }
            try {
                String encoding = (String)this.message.get((Object)Message.ENCODING);
                HapInvokeOutInterceptor.this.writePayload(buffer.getPayload(), cos, encoding, ct);
                if (invokeOut != null) {
                    invokeOut.setRequestParameter(buffer.getPayload().toString());
                } else if (inbound != null) {
                    inbound.setResponseContent(buffer.getPayload().toString());
                    inbound.setResponseTime(System.currentTimeMillis() - inbound.getRequestTime().getTime());
                    inbound.setRequestStatus("success");
                    HapInvokeOutInterceptor.this.messagePublisher.message("invoke.inbound", new HapinterfaceBound(inbound));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                cos.lockOutputStream();
                cos.resetOut(null, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.message.setContent(OutputStream.class, (Object)this.origStream);
        }
    }
}

