/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.hr.controllers;

import com.hand.hap.account.dto.User;
import com.hand.hap.core.IRequest;
import com.hand.hap.hr.dto.Employee;
import com.hand.hap.hr.dto.UserAndRoles;
import com.hand.hap.hr.service.IEmployeeService;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.mybatis.common.query.Comparison;
import com.hand.hap.mybatis.common.query.WhereField;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hr/employee", "/api/hr/employee"})
public class EmployeeController
extends BaseController {
    @Autowired
    private IEmployeeService employeeService;

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData query(Employee employee, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        Criteria criteria = new Criteria(employee);
        criteria.where(new WhereField("employeeCode", Comparison.LIKE), "employeeId", "name");
        return new ResponseData(this.employeeService.selectOptions(requestContext, employee, criteria, page, pagesize));
    }

    @RequestMapping(value={"/queryAll"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData queryAll(Employee employee, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.employeeService.queryAll(requestContext, employee, page, pagesize));
    }

    @PostMapping(value={"/submit"})
    public ResponseData submit(@RequestBody List<Employee> employees, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(employees, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.employeeService.submit(requestContext, employees));
    }

    @PostMapping(value={"/create_user"})
    public ResponseData createUserByEmployee(@RequestBody UserAndRoles userAndRoles, HttpServletRequest request) {
        IRequest request1 = this.createRequestContext(request);
        this.employeeService.createUserByEmployee(request1, userAndRoles);
        return new ResponseData();
    }

    @PostMapping(value={"/update_user"})
    public ResponseData updateUser(@RequestBody UserAndRoles userAndRoles, HttpServletRequest request, @RequestParam(required=false) String userName) {
        IRequest irequest = this.createRequestContext(request);
        this.employeeService.updateUser(irequest, userAndRoles, userName);
        return new ResponseData();
    }

    @PostMapping(value={"/queryExistingUser"})
    public ResponseData queryUsers(HttpServletRequest request, @ModelAttribute User user) {
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.employeeService.selectExistingUser(iRequest, user));
    }
}

