/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.generator.service.impl;

import com.hand.hap.generator.dto.DBColumn;
import com.hand.hap.generator.dto.DBTable;
import com.hand.hap.generator.dto.GeneratorInfo;
import com.hand.hap.generator.service.IHapGeneratorService;
import com.hand.hap.generator.service.impl.DBUtil;
import com.hand.hap.generator.service.impl.FileUtil;
import com.hand.hap.mybatis.util.StringUtil;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class HapGeneratorServiceImpl
implements IHapGeneratorService {
    @Autowired
    @Qualifier(value="sqlSessionFactory")
    SqlSessionFactory sqlSessionFactory;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> showTables() {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            Connection conn = DBUtil.getConnectionBySqlSession(sqlSession);
            List<String> tables = DBUtil.showAllTables(conn);
            conn.close();
            List<String> list = tables;
            return list;
        }
        catch (SQLException e) {
            this.logger.error("\u6570\u636e\u5e93\u67e5\u8be2\u51fa\u9519");
            return new ArrayList<String>();
        }
    }

    @Override
    public int generatorFile(GeneratorInfo info) {
        int rs = 0;
        String tableName = info.getTargetName();
        DBTable dbTable = this.getTableInfo(tableName);
        try {
            rs = this.createFile(dbTable, info);
        }
        catch (IOException e) {
            rs = -1;
            this.logger.error(e.getMessage());
        }
        catch (TemplateException e) {
            rs = -1;
            this.logger.error(e.getMessage());
        }
        return rs;
    }

    public DBTable getTableInfo(String tableName) {
        Connection conn = null;
        DBTable dbTable = new DBTable();
        List<DBColumn> columns = dbTable.getColumns();
        List<String> multiColumns = null;
        List<String> NotNullColumns = null;
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            dbTable.setName(tableName);
            conn = DBUtil.getConnectionBySqlSession(sqlSession);
            DatabaseMetaData dbmd = conn.getMetaData();
            boolean multiLanguage = DBUtil.isMultiLanguageTable(tableName);
            if (multiLanguage) {
                dbTable.setMultiLanguage(multiLanguage);
                multiColumns = DBUtil.isMultiLanguageColumn(tableName, dbmd);
            }
            String columnPk = DBUtil.getPrimaryKey(tableName, dbmd);
            NotNullColumns = DBUtil.getNotNullColumn(tableName, dbmd);
            ResultSet rs1 = DBUtil.getTableColumnInfo(tableName, dbmd);
            while (rs1.next()) {
                String columnName = rs1.getString("COLUMN_NAME");
                if ("OBJECT_VERSION_NUMBER".equalsIgnoreCase(columnName) || "REQUEST_ID".equalsIgnoreCase(columnName) || "PROGRAM_ID".equalsIgnoreCase(columnName) || "CREATED_BY".equalsIgnoreCase(columnName) || "CREATION_DATE".equalsIgnoreCase(columnName) || "LAST_UPDATED_BY".equalsIgnoreCase(columnName) || "LAST_UPDATE_DATE".equalsIgnoreCase(columnName) || "LAST_UPDATE_LOGIN".equalsIgnoreCase(columnName) || columnName.toUpperCase().startsWith("ATTRIBUTE")) continue;
                columns.add(this.setColumnInfo(rs1, columnPk, NotNullColumns, multiLanguage, multiColumns));
            }
            rs1.close();
            conn.close();
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage());
        }
        return dbTable;
    }

    private DBColumn setColumnInfo(ResultSet rs1, String columnPk, List<String> NotNullColumns, boolean multiLanguage, List<String> multiColumns) throws SQLException {
        DBColumn column = new DBColumn();
        String columnName = rs1.getString("COLUMN_NAME");
        column.setName(columnName);
        String typeName = rs1.getString("TYPE_NAME");
        column.setJdbcType(typeName);
        if (StringUtil.isNotEmpty(rs1.getString("REMARKS"))) {
            column.setRemarks(rs1.getString("REMARKS"));
        }
        if (columnName.equalsIgnoreCase(columnPk)) {
            column.setId(true);
        }
        for (String n : NotNullColumns) {
            if (!columnName.equalsIgnoreCase(n) || columnName.equalsIgnoreCase(columnPk)) continue;
            if ("BIGINT".equalsIgnoreCase(typeName)) {
                column.setNotNull(true);
                continue;
            }
            if (!"VARCHAR".equalsIgnoreCase(typeName)) continue;
            column.setNotEmpty(true);
        }
        if (multiLanguage) {
            for (String m : multiColumns) {
                if (!m.equals(columnName)) continue;
                column.setMultiLanguage(true);
                break;
            }
        }
        column.setColumnLength(rs1.getString("COLUMN_SIZE"));
        return column;
    }

    public int createFile(DBTable table, GeneratorInfo info) throws IOException, TemplateException {
        int rs = FileUtil.isFileExist(info);
        if (rs == 0) {
            if (!"NotOperation".equalsIgnoreCase(info.getDtoStatus())) {
                FileUtil.createDto(table, info);
            }
            if (!"NotOperation".equalsIgnoreCase(info.getControllerStatus())) {
                FileUtil.createFtlInfoByType(FileUtil.pType.Controller, table, info);
            }
            if (!"NotOperation".equalsIgnoreCase(info.getMapperStatus())) {
                FileUtil.createFtlInfoByType(FileUtil.pType.Mapper, table, info);
            }
            if (!"NotOperation".equalsIgnoreCase(info.getImplStatus())) {
                FileUtil.createFtlInfoByType(FileUtil.pType.Impl, table, info);
            }
            if (!"NotOperation".equalsIgnoreCase(info.getServiceStatus())) {
                FileUtil.createFtlInfoByType(FileUtil.pType.Service, table, info);
            }
            if (!"NotOperation".equalsIgnoreCase(info.getMapperXmlStatus())) {
                FileUtil.createFtlInfoByType(FileUtil.pType.MapperXml, table, info);
            }
            if (!"NotOperation".equalsIgnoreCase(info.getHtmlStatus())) {
                FileUtil.createFtlInfoByType(FileUtil.pType.Html, table, info);
            }
        }
        return rs;
    }
}

