/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.fnd.dto;

import com.hand.hap.core.annotation.MultiLanguage;
import com.hand.hap.core.annotation.MultiLanguageField;
import com.hand.hap.hr.dto.Position;
import com.hand.hap.mybatis.common.query.Comparison;
import com.hand.hap.mybatis.common.query.JoinCode;
import com.hand.hap.mybatis.common.query.JoinColumn;
import com.hand.hap.mybatis.common.query.JoinOn;
import com.hand.hap.mybatis.common.query.JoinTable;
import com.hand.hap.mybatis.common.query.Where;
import com.hand.hap.system.dto.BaseDTO;
import java.util.Date;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.criteria.JoinType;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@MultiLanguage
@Table(name="FND_COMPANY_B")
public class Company
extends BaseDTO {
    public static final String FIELD_COMPANY_ID = "companyId";
    public static final String FIELD_COMPANY_CODE = "companyCode";
    public static final String FIELD_COMPANY_TYPE = "companyType";
    public static final String FIELD_ADDRESS = "address";
    public static final String FIELD_COMPANY_LEVEL_ID = "companyLevelId";
    public static final String FIELD_PARENT_COMPANY_ID = "parentCompanyId";
    public static final String FIELD_CHIEF_POSITION_ID = "chiefPositionId";
    public static final String FIELD_START_DATE_ACTIVE = "startDateActive";
    public static final String FIELD_END_DATE_ACTIVE = "endDateActive";
    public static final String FIELD_COMPANY_SHORT_NAME = "companyShortName";
    public static final String FIELD_COMPANY_FULL_NAME = "companyFullName";
    public static final String FIELD_ZIPCODE = "zipcode";
    public static final String FIELD_FAX = "fax";
    public static final String FIELD_PHONE = "phone";
    public static final String FIELD_CONTACT_PERSON = "contactPerson";
    public static final String FIELD_PARENT_COMPANY_NAME = "parentCompanyName";
    public static final String FIELD_POSITION_NAME = "positionName";
    @Id
    @GeneratedValue
    private Long companyId;
    @NotEmpty
    @Where
    @Length(max=30)
    @OrderBy(value="ASC")
    private String companyCode;
    @Where
    @Length(max=30)
    private String companyType;
    @Transient
    @JoinCode(code="FND.COMPANY_TYPE", joinKey="companyType")
    private String companyTypeName;
    @Length(max=250)
    private String address;
    private Long companyLevelId;
    @Transient
    @JoinCode(code="FND.COMPANY_LEVEL", joinKey="companyLevelId")
    private String companyLevelName;
    @Where
    @JoinTable(name="companyJoin", joinMultiLanguageTable=true, target=Company.class, type=JoinType.LEFT, on={@JoinOn(joinField="companyId"), @JoinOn(joinField="lang", joinExpression="#{request.locale,jdbcType=VARCHAR,javaType=java.lang.String}")})
    private Long parentCompanyId;
    @JoinTable(name="positionJoin", joinMultiLanguageTable=true, target=Position.class, type=JoinType.LEFT, on={@JoinOn(joinField="positionId"), @JoinOn(joinField="lang", joinExpression="#{request.locale,jdbcType=VARCHAR,javaType=java.lang.String}")})
    private Long chiefPositionId;
    private Date startDateActive;
    private Date endDateActive;
    @NotEmpty
    @MultiLanguageField
    @Length(max=250)
    @Where(comparison=Comparison.LIKE)
    private String companyShortName;
    @NotEmpty
    @MultiLanguageField
    @Where(comparison=Comparison.LIKE)
    @Length(max=250)
    private String companyFullName;
    @Length(max=100)
    private String zipcode;
    @Length(max=100)
    private String fax;
    @Length(max=100)
    private String phone;
    @Length(max=100)
    private String contactPerson;
    @Transient
    @JoinColumn(joinName="companyJoin", field="companyFullName")
    private String parentCompanyName;
    @Transient
    @JoinColumn(joinName="positionJoin", field="name")
    private String positionName;

    public Long getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public String getCompanyCode() {
        return this.companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = StringUtils.trim((String)companyCode);
    }

    public String getCompanyType() {
        return this.companyType;
    }

    public void setCompanyType(String companyType) {
        this.companyType = companyType;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Long getCompanyLevelId() {
        return this.companyLevelId;
    }

    public void setCompanyLevelId(Long companyLevelId) {
        this.companyLevelId = companyLevelId;
    }

    public Long getParentCompanyId() {
        return this.parentCompanyId;
    }

    public void setParentCompanyId(Long parentCompanyId) {
        this.parentCompanyId = parentCompanyId;
    }

    public Long getChiefPositionId() {
        return this.chiefPositionId;
    }

    public void setChiefPositionId(Long chiefPositionId) {
        this.chiefPositionId = chiefPositionId;
    }

    public Date getStartDateActive() {
        return this.startDateActive;
    }

    public void setStartDateActive(Date startDateActive) {
        this.startDateActive = startDateActive;
    }

    public Date getEndDateActive() {
        return this.endDateActive;
    }

    public void setEndDateActive(Date endDateActive) {
        this.endDateActive = endDateActive;
    }

    public String getCompanyShortName() {
        return this.companyShortName;
    }

    public void setCompanyShortName(String companyShortName) {
        this.companyShortName = StringUtils.trim((String)companyShortName);
    }

    public String getCompanyFullName() {
        return this.companyFullName;
    }

    public void setCompanyFullName(String companyFullName) {
        this.companyFullName = StringUtils.trim((String)companyFullName);
    }

    public String getZipcode() {
        return this.zipcode;
    }

    public void setZipcode(String zipcode) {
        this.zipcode = zipcode;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getContactPerson() {
        return this.contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getParentCompanyName() {
        return this.parentCompanyName;
    }

    public void setParentCompanyName(String parentCompanyName) {
        this.parentCompanyName = parentCompanyName;
    }

    public String getPositionName() {
        return this.positionName;
    }

    public void setPositionName(String positionName) {
        this.positionName = positionName;
    }

    public String getCompanyTypeName() {
        return this.companyTypeName;
    }

    public void setCompanyTypeName(String companyTypeName) {
        this.companyTypeName = companyTypeName;
    }

    public String getCompanyLevelName() {
        return this.companyLevelName;
    }

    public void setCompanyLevelName(String companyLevelName) {
        this.companyLevelName = companyLevelName;
    }
}

