/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.excel.util;

import com.hand.hap.core.annotation.Children;
import com.hand.hap.core.annotation.MultiLanguage;
import com.hand.hap.core.annotation.MultiLanguageField;
import com.hand.hap.core.components.ApplicationContextHelper;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.excel.annotation.ExcelJoinColumn;
import com.hand.hap.excel.service.impl.ExcelSheetStrategy;
import com.hand.hap.generator.service.impl.FileUtil;
import com.hand.hap.mybatis.common.BaseMapper;
import com.hand.hap.mybatis.entity.EntityColumn;
import com.hand.hap.mybatis.entity.EntityTable;
import com.hand.hap.mybatis.mapperhelper.EntityHelper;
import com.hand.hap.mybatis.mapperhelper.MapperHelper;
import com.hand.hap.mybatis.mapperhelper.MapperTemplate;
import com.hand.hap.mybatis.spring.MapperScannerConfigurer;
import com.hand.hap.system.dto.Prompt;
import com.hand.hap.system.mapper.LanguageMapper;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.LocaleUtils;
import org.springframework.context.MessageSource;

public class TableUtils {
    public static List<String> STDWHO_COLUMN = new ArrayList<String>();

    public static Class getTableClass(String tableName) {
        return EntityHelper.getEntityTable(tableName).getEntityClass();
    }

    public static EntityTable getTable(Class dto) {
        return EntityHelper.getEntityTable(dto);
    }

    public static List<Field> getExcelJoinColumns(String tableName) {
        Class tableClass = TableUtils.getTableClass(tableName);
        return TableUtils.getExcelJoinColumn(tableClass);
    }

    public static List<Field> getExcelJoinColumn(Class tableDto) {
        return Arrays.stream(tableDto.getDeclaredFields()).filter(v -> v.isAnnotationPresent(ExcelJoinColumn.class)).collect(Collectors.toList());
    }

    public static List<Field> getMultiLanguageColumn(Class tableDto) {
        if (!tableDto.isAnnotationPresent(MultiLanguage.class)) {
            return new ArrayList<Field>();
        }
        return Arrays.stream(tableDto.getDeclaredFields()).filter(v -> v.isAnnotationPresent(MultiLanguageField.class)).collect(Collectors.toList());
    }

    public static List<Field> getChildrenColumn(Class dto) {
        return Arrays.stream(dto.getDeclaredFields()).filter(v -> v.isAnnotationPresent(Children.class)).collect(Collectors.toList());
    }

    public static BaseMapper getBaseMapperByType(Class dtoClass, ExcelSheetStrategy.MapperType mapperType) throws ClassNotFoundException {
        MapperHelper helper;
        String uri = mapperType == ExcelSheetStrategy.MapperType.Insert ? "com.hand.hap.mybatis.common.base.insert.InsertMapper" : "com.hand.hap.mybatis.common.base.select.SelectAllMapper";
        ArrayList lists = new ArrayList();
        ApplicationContextHelper.getApplicationContext().getBeansOfType(MapperScannerConfigurer.class).forEach((k, v) -> lists.add(v.getMapperHelper()));
        MapperTemplate template = null;
        Iterator iterator = lists.iterator();
        while (iterator.hasNext() && (template = (helper = (MapperHelper)iterator.next()).getRegisterMapper(Class.forName(uri))) == null) {
        }
        Map<String, Class<?>> map = template.getEntityClassMap();
        if (!map.containsValue(dtoClass)) {
            throw new ClassNotFoundException();
        }
        String key = "";
        Set<String> kset = map.keySet();
        for (String ks : kset) {
            if (!map.get(ks).equals(dtoClass)) continue;
            key = ks;
            break;
        }
        if ("" == key) {
            throw new ClassNotFoundException();
        }
        return (BaseMapper)ApplicationContextHelper.getApplicationContext().getBean(Class.forName(key.substring(0, key.lastIndexOf("."))));
    }

    public static Set getAllColumns(String tableName) {
        return EntityHelper.getEntityTable(tableName).getAllColumns();
    }

    public static List<String> getTitle(List<String> column, Class dto) {
        String lang = RequestHelper.getCurrentRequest(true).getLocale();
        MessageSource messageSource = (MessageSource)ApplicationContextHelper.getApplicationContext().getBean(MessageSource.class);
        return column.stream().map(v -> {
            Prompt prompt = new Prompt();
            String title = dto.getSimpleName().toLowerCase() + "." + v.toLowerCase();
            prompt.setPromptCode(title);
            prompt.setLang(lang);
            title = messageSource.getMessage(title, null, LocaleUtils.toLocale((String)lang));
            return title;
        }).collect(Collectors.toList());
    }

    public static List<String> getColumn(EntityTable tableEntity, List<String> containColumns) {
        return TableUtils.getColumn(tableEntity, containColumns, true);
    }

    public static List<String> getColumn(EntityTable tableEntity, List<String> containColumns, boolean containStdWho) {
        Class<?> dto = tableEntity.getEntityClass();
        String dtoName = dto.getSimpleName();
        List<Field> joinColumn = TableUtils.getExcelJoinColumn(dto);
        List<Field> languageColumns = TableUtils.getMultiLanguageColumn(dto);
        ArrayList<String> column = new ArrayList<String>();
        Set<EntityColumn> allColumns = tableEntity.getAllColumns();
        if (null != containColumns) {
            allColumns.stream().map(m -> FileUtil.columnToCamel(m.getColumn())).filter(u -> containColumns.contains(dtoName + "." + u)).forEach(v -> column.add((String)v));
        } else {
            allColumns.stream().map(m -> FileUtil.columnToCamel(m.getColumn())).forEach(v -> column.add((String)v));
        }
        if (languageColumns.size() != 0 && null == containColumns) {
            List languages = ((LanguageMapper)ApplicationContextHelper.getApplicationContext().getBean(LanguageMapper.class)).selectAll();
            languageColumns.forEach(v -> {
                if (column.contains(v.getName())) {
                    languages.stream().forEach(u -> column.add(v.getName() + ":" + u.getLangCode()));
                }
            });
        }
        if (!containStdWho) {
            column.removeAll(STDWHO_COLUMN);
        }
        return column;
    }

    public static void getAllChildrenTable(Class parentTableName, List<Class> tables) {
        tables.add(parentTableName);
        TableUtils.getChildren(parentTableName).forEach(v -> TableUtils.getAllChildrenTable(v, tables));
    }

    public static List<Class> getChildren(Class entityTable) {
        ArrayList<Class> tables = new ArrayList<Class>();
        List<Field> childrenField = TableUtils.getChildrenColumn(entityTable);
        if (childrenField.size() != 0) {
            for (int i = 0; i < childrenField.size(); ++i) {
                Class entityClass;
                Type type = childrenField.get(i).getGenericType();
                if (type instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    entityClass = (Class)parameterizedType.getActualTypeArguments()[0];
                } else {
                    entityClass = (Class)type;
                }
                tables.add(entityClass);
            }
        }
        return tables;
    }

    static {
        STDWHO_COLUMN.add("createdBy");
        STDWHO_COLUMN.add("objectVersionNumber");
        STDWHO_COLUMN.add("programId");
        STDWHO_COLUMN.add("requestId");
        STDWHO_COLUMN.add("creationDate");
        STDWHO_COLUMN.add("lastUpdateDate");
        STDWHO_COLUMN.add("lastUpdateLogin");
        STDWHO_COLUMN.add("lastUpdatedBy");
    }
}

