/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.excel.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.excel.dto.ColumnInfo;
import com.hand.hap.excel.dto.ExportConfig;
import com.hand.hap.excel.service.IExportService;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

@Service
public class ExportServiceImpl
implements IExportService {
    private static final String ENC = "UTF-8";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="sqlSessionFactory")
    SqlSessionFactory sqlSessionFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportExcel(String sqlId, ExportConfig gridInfo, IRequest iRequest, OutputStream outputStream, int rowMaxNumber) throws IOException {
        SXSSFWorkbook wb = new SXSSFWorkbook(50);
        CellStyle dateFormat = wb.createCellStyle();
        dateFormat.setDataFormat(wb.createDataFormat().getFormat("yyyy-MM-DD HH:mm:ss"));
        AtomicInteger count = new AtomicInteger(1);
        AtomicInteger rowIndex = new AtomicInteger(1);
        this.initColumnType(gridInfo.getColumnsInfo(), gridInfo.getParam());
        SXSSFSheet[] sheet = new SXSSFSheet[]{wb.createSheet()};
        this.createHeaderRow(gridInfo.getColumnsInfo(), wb, sheet[0]);
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            sqlSession.select(sqlId, gridInfo.getParam(), resultContext -> {
                Object object = resultContext.getResultObject();
                sheet[0] = this.createSheet(wb, sheet[0], object, count, rowIndex, rowMaxNumber, gridInfo, dateFormat);
            });
            wb.write(outputStream);
        }
        finally {
            wb.close();
            wb.dispose();
        }
    }

    private SXSSFSheet createSheet(SXSSFWorkbook wb, SXSSFSheet sheet, Object object, AtomicInteger count, AtomicInteger rowIndex, int rowMaxNumber, ExportConfig gridInfo, CellStyle dateFormat) {
        if (count.get() % rowMaxNumber == 0) {
            sheet = wb.createSheet();
            this.createHeaderRow(gridInfo.getColumnsInfo(), wb, sheet);
            rowIndex.set(0);
        }
        count.getAndIncrement();
        SXSSFRow row = sheet.createRow(rowIndex.getAndIncrement());
        this.createRow(gridInfo.getColumnsInfo(), object, row, dateFormat);
        return sheet;
    }

    private void createRow(List<ColumnInfo> columnInfos, Object object, SXSSFRow row, CellStyle dateFormat) {
        block19: for (int ii = 0; ii < columnInfos.size(); ++ii) {
            Object fieldObject = null;
            try {
                fieldObject = PropertyUtils.getProperty((Object)object, (String)columnInfos.get(ii).getName());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            String type = columnInfos.get(ii).getType();
            SXSSFCell cell = row.createCell(ii);
            if (null == fieldObject) {
                cell.setCellType(CellType.STRING);
                cell.setCellValue((String)null);
                continue;
            }
            switch (type.toUpperCase()) {
                case "NUMBER": 
                case "FLOAT": {
                    cell.setCellType(CellType.NUMERIC);
                    cell.setCellValue((double)((Float)fieldObject).floatValue());
                    continue block19;
                }
                case "DOUBLE": {
                    cell.setCellType(CellType.NUMERIC);
                    cell.setCellValue(((Double)fieldObject).doubleValue());
                    continue block19;
                }
                case "INT": 
                case "INTEGER": 
                case "LONG": {
                    cell.setCellType(CellType.NUMERIC);
                    cell.setCellValue((double)((Long)fieldObject).longValue());
                    continue block19;
                }
                case "DATE": {
                    cell.setCellStyle(dateFormat);
                    cell.setCellValue((Date)fieldObject);
                    continue block19;
                }
                case "BOOLEAN": {
                    cell.setCellType(CellType.BOOLEAN);
                    cell.setCellValue(((Boolean)fieldObject).booleanValue());
                    continue block19;
                }
                default: {
                    cell.setCellType(CellType.STRING);
                    cell.setCellValue((String)fieldObject);
                }
            }
        }
    }

    private void createHeaderRow(List<ColumnInfo> columnInfos, SXSSFWorkbook wb, SXSSFSheet sheet) {
        SXSSFRow firstRow = sheet.createRow(0);
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        for (int i = 0; i < columnInfos.size(); ++i) {
            SXSSFCell firstCell = firstRow.createCell(i);
            firstCell.setCellValue(columnInfos.get(i).getTitle());
            sheet.setColumnWidth(i, columnInfos.get(i).getWidth() * 80);
            firstCell.setCellStyle(cellStyle);
        }
    }

    private void initColumnType(List<ColumnInfo> columnInfos, Object object) {
        for (ColumnInfo columnInfo : columnInfos) {
            columnInfo.setType(ReflectionUtils.findField(object.getClass(), (String)columnInfo.getName()).getType().getSimpleName());
        }
    }

    @Override
    public void exportAndDownloadExcel(String sqlId, ExportConfig exportConfig, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, IRequest iRequest, int rowMaxNumber) throws IOException {
        String name = exportConfig.getFileName() + ".xlsx";
        String userAgent = httpServletRequest.getHeader("User-Agent");
        name = userAgent.contains("Firefox") ? new String(name.getBytes(ENC), "ISO8859-1") : URLEncoder.encode(name, ENC);
        httpServletResponse.addHeader("Content-Disposition", "attachment; filename=\"" + name + "\"");
        httpServletResponse.setContentType("application/vnd.ms-excel;charset=UTF-8");
        httpServletResponse.setHeader("Accept-Ranges", "bytes");
        try (ServletOutputStream outputStream = httpServletResponse.getOutputStream();){
            this.exportExcel(sqlId, exportConfig, iRequest, (OutputStream)outputStream, rowMaxNumber);
        }
    }

    @Override
    public void exportAndDownloadExcel(String sqlId, ExportConfig exportConfig, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, IRequest iRequest) throws IOException {
        this.exportAndDownloadExcel(sqlId, exportConfig, httpServletRequest, httpServletResponse, iRequest, 1000000);
    }
}

