/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.excel.service.impl;

import com.hand.hap.core.annotation.MultiLanguage;
import com.hand.hap.core.components.ApplicationContextHelper;
import com.hand.hap.excel.annotation.ExcelJoinColumn;
import com.hand.hap.excel.util.TableUtils;
import com.hand.hap.generator.service.impl.FileUtil;
import com.hand.hap.system.dto.Language;
import com.hand.hap.system.mapper.LanguageMapper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;

public class ExcelSheetStrategy {
    protected Connection connection;
    protected String tableName;
    protected List<String> columnName;
    protected Class dtoClass;
    protected List<Field> excelJoinColumns;
    protected Map<String, Class> typeMapping = new HashMap<String, Class>();
    protected Map<String, Object> translateCellMap = new HashMap<String, Object>();
    protected List<Language> languages;

    public ExcelSheetStrategy(Connection connection, String tableName) throws ClassNotFoundException {
        this.tableName = tableName;
        this.connection = connection;
        this.dtoClass = TableUtils.getTableClass(tableName);
        this.excelJoinColumns = TableUtils.getExcelJoinColumns(tableName);
        Set entityColumns = TableUtils.getAllColumns(tableName);
        entityColumns.stream().forEach(v -> this.typeMapping.put(FileUtil.columnToCamel(v.getColumn()), v.getJavaType()));
        if (this.dtoClass.isAnnotationPresent(MultiLanguage.class)) {
            this.languages = ((LanguageMapper)ApplicationContextHelper.getApplicationContext().getBean(LanguageMapper.class)).selectAll();
        }
    }

    protected boolean translateLanguageCell(String column, String cell, Map tls) throws InvocationTargetException, IllegalAccessException {
        for (Language language : this.languages) {
            if (!column.endsWith(":" + language.getLangCode())) continue;
            String col = column.substring(0, column.length() - language.getLangCode().length() - 1);
            Map map = (Map)Optional.ofNullable(tls.get(col)).orElseGet(() -> {
                HashMap map2 = new HashMap();
                tls.put(col, map2);
                return map2;
            });
            map.put(language.getLangCode(), cell);
            return true;
        }
        return false;
    }

    protected Object translateCellValue(String column, String cell, TranslateType translateType, Object dto) throws SQLException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException {
        Object rs = cell;
        if (null == cell || "" == cell) {
            return null;
        }
        for (Field field : this.excelJoinColumns) {
            ExcelJoinColumn ann = ((ExcelJoinColumn[])field.getAnnotationsByType(ExcelJoinColumn.class))[0];
            if (!field.getName().equalsIgnoreCase(column)) continue;
            if (null != dto) {
                cell = BeanUtils.getProperty((Object)dto, (String)column);
            }
            if (this.translateCellMap.containsKey(column + "-" + cell)) {
                return this.translateCellMap.get(column + "-" + cell);
            }
            String joinColumn = ann.JoinColumn();
            String alternateColumn = ann.AlternateColumn();
            String joinTable = TableUtils.getTable(ann.JoinTable()).getName();
            String sql = translateType == TranslateType.alterColumnTojoinColumn ? "select " + FileUtil.camelToColumn(joinColumn) + " from " + joinTable + " where " + FileUtil.camelToColumn(alternateColumn) + " = '" + cell + "'" : "select " + FileUtil.camelToColumn(alternateColumn) + " from " + joinTable + " where " + FileUtil.camelToColumn(joinColumn) + " = '" + cell + "'";
            PreparedStatement stmt1 = this.connection.prepareStatement(sql);
            ResultSet set = stmt1.executeQuery();
            if (set.next()) {
                rs = set.getObject(1);
                this.translateCellMap.put(column + "-" + cell, rs);
                this.changeTypeMapping(column, ann.AlternateColumn(), ann.JoinTable());
            }
            stmt1.close();
            break;
        }
        return rs;
    }

    public void changeTypeMapping(String column, String alternateColumn, Class cls) throws NoSuchFieldException {
        this.typeMapping.replace(column, cls.getDeclaredField(alternateColumn).getType());
    }

    protected void cleanData() {
        this.tableName = null;
        this.columnName = null;
        this.dtoClass = null;
        this.excelJoinColumns = null;
        this.typeMapping = new HashMap<String, Class>();
        this.translateCellMap = new HashMap<String, Object>();
    }

    public static enum MapperType {
        Select,
        Insert;

    }

    public static enum TranslateType {
        alterColumnTojoinColumn,
        joinColumnToAlterCloumn;

    }
}

