/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view.ui;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.hand.hap.core.web.view.ReferenceType;
import com.hand.hap.core.web.view.XMap;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GridColumnFilterable {
    private Map<String, Object> cell;
    private Boolean multi;
    private ReferenceType dataSource;
    private Boolean checkAll;
    private ReferenceType itemTemplate;
    private Map<Object, Object> operators;
    private Boolean search;
    private Boolean ignoreCase;
    private Object ui;
    private static final String PROPERTITY_CELL = "cell";
    private static final String PROPERTITY_DATA_TEXT_FIELD = "dataTextField";
    private static final String PROPERTITY_DELAY = "delay";
    private static final String PROPERTITY_INPUT_WIDTH = "inputWidth";
    private static final String PROPERTITY_SUGGESTION_OPERATOR = "suggestionOperator";
    private static final String PROPERTITY_MIN_LENGTH = "minLength";
    private static final String PROPERTITY_ENABLED = "enable";
    private static final String PROPERTITY_OPERATOR = "operator";
    private static final String PROPERTITY_SHOW_OPERATORS = "showOperators";
    private static final String PROPERTITY_TEMPLATE = "template";
    private static final String PROPERTITY_MULTI = "multi";
    private static final String PROPERTITY_DATA_SOURCE = "dataSource";
    private static final String PROPERTITY_CHECK_ALL = "checkAll";
    private static final String PROPERTITY_ITEM_TEMPLATE = "itemTemplate";
    private static final String PROPERTITY_OPERATORS = "operators";
    private static final String PROPERTITY_SEARCH = "search";
    private static final String PROPERTITY_IGNORE_CASE = "ignoreCase";
    private static final String PROPERTITY_UI = "ui";

    public static GridColumnFilterable parseFilterable(XMap view) {
        GridColumnFilterable filterable = new GridColumnFilterable();
        filterable.setCell(GridColumnFilterable.parseCell(view.getChild(PROPERTITY_CELL)));
        filterable.setMulti(view.getBoolean(PROPERTITY_MULTI));
        filterable.setDataSource(ReferenceType.create(view.getString(PROPERTITY_DATA_SOURCE)));
        filterable.setCheckAll(view.getBoolean(PROPERTITY_CHECK_ALL));
        filterable.setItemTemplate(ReferenceType.create(view.getString(PROPERTITY_ITEM_TEMPLATE)));
        filterable.setOperators(view.getChild(PROPERTITY_OPERATORS));
        filterable.setSearch(view.getBoolean(PROPERTITY_SEARCH));
        filterable.setIgnoreCase(view.getBoolean(PROPERTITY_IGNORE_CASE));
        filterable.setUi(view.getPropertity(PROPERTITY_UI));
        return filterable;
    }

    public XMap toXMap() {
        XMap filterable = new XMap("h", "http://www.hand-china.com/hap", "filterable");
        XMap cell = new XMap("h", "http://www.hand-china.com/hap", PROPERTITY_CELL);
        if (this.getCell() != null) {
            for (Map.Entry<String, Object> entry : this.getCell().entrySet()) {
                cell.put(entry.getKey(), entry.getValue());
            }
        }
        filterable.addChild(cell);
        filterable.put(PROPERTITY_MULTI, this.getMulti());
        filterable.put(PROPERTITY_DATA_SOURCE, this.getDataSource());
        filterable.put(PROPERTITY_CHECK_ALL, this.getCheckAll());
        filterable.put(PROPERTITY_ITEM_TEMPLATE, this.getItemTemplate());
        XMap operators = new XMap("h", "http://www.hand-china.com/hap", PROPERTITY_OPERATORS);
        if (this.getOperators() != null) {
            for (Map.Entry<Object, Object> entry : this.getOperators().entrySet()) {
                operators.put(entry.getKey(), entry.getValue());
            }
        }
        filterable.addChild(operators);
        filterable.put(PROPERTITY_SEARCH, this.getMulti());
        filterable.put(PROPERTITY_IGNORE_CASE, this.getMulti());
        filterable.put(PROPERTITY_UI, this.getUi());
        return filterable;
    }

    public static Map<String, Object> parseCell(XMap view) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (view != null) {
            String dataSource1 = view.getString(PROPERTITY_DATA_SOURCE);
            if (dataSource1 != null) {
                map.put(PROPERTITY_DATA_SOURCE, new ReferenceType(dataSource1));
            }
            if (view.getDouble(PROPERTITY_DELAY) != null) {
                map.put(PROPERTITY_DELAY, view.getDouble(PROPERTITY_DELAY));
            }
            if (view.getDouble(PROPERTITY_INPUT_WIDTH) != null) {
                map.put(PROPERTITY_INPUT_WIDTH, view.getDouble(PROPERTITY_INPUT_WIDTH));
            }
            if (view.getDouble(PROPERTITY_MIN_LENGTH) != null) {
                map.put(PROPERTITY_MIN_LENGTH, view.getDouble(PROPERTITY_MIN_LENGTH));
            }
            if (view.getBoolean(PROPERTITY_ENABLED) != null) {
                map.put(PROPERTITY_ENABLED, view.getBoolean(PROPERTITY_ENABLED));
            }
            if (view.getBoolean(PROPERTITY_SHOW_OPERATORS) != null) {
                map.put(PROPERTITY_SHOW_OPERATORS, view.getBoolean(PROPERTITY_SHOW_OPERATORS));
            }
            if (view.getPropertity(PROPERTITY_TEMPLATE) != null) {
                map.put(PROPERTITY_TEMPLATE, view.getPropertity(PROPERTITY_TEMPLATE));
            }
            if (view.getString(PROPERTITY_DATA_TEXT_FIELD) != null) {
                map.put(PROPERTITY_DATA_TEXT_FIELD, view.getString(PROPERTITY_DATA_TEXT_FIELD));
            }
            if (view.getString(PROPERTITY_SUGGESTION_OPERATOR) != null) {
                map.put(PROPERTITY_SUGGESTION_OPERATOR, view.getString(PROPERTITY_SUGGESTION_OPERATOR));
            }
            if (view.getString(PROPERTITY_OPERATOR) != null) {
                map.put(PROPERTITY_OPERATOR, view.getString(PROPERTITY_OPERATOR));
            }
        }
        return map;
    }

    public Map<String, Object> getCell() {
        return this.cell;
    }

    public void setCell(Map<String, Object> cell) {
        this.cell = cell;
    }

    public Boolean getMulti() {
        return this.multi;
    }

    public void setMulti(Boolean multi) {
        this.multi = multi;
    }

    public ReferenceType getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ReferenceType dataSource) {
        this.dataSource = dataSource;
    }

    public Boolean getCheckAll() {
        return this.checkAll;
    }

    public void setCheckAll(Boolean checkAll) {
        this.checkAll = checkAll;
    }

    public ReferenceType getItemTemplate() {
        return this.itemTemplate;
    }

    public void setItemTemplate(ReferenceType itemTemplate) {
        this.itemTemplate = itemTemplate;
    }

    public Map<Object, Object> getOperators() {
        return this.operators;
    }

    public void setOperators(Map<Object, Object> operators) {
        this.operators = operators;
    }

    public Boolean getSearch() {
        return this.search;
    }

    public void setSearch(Boolean search) {
        this.search = search;
    }

    public Boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(Boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public Object getUi() {
        return this.ui;
    }

    public void setUi(Object ui) {
        this.ui = ui;
    }
}

