/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.validator;

import com.hand.hap.core.validator.FieldErrorWithBean;
import com.hand.hap.mybatis.entity.EntityField;
import com.hand.hap.system.dto.DTOClassInfo;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.beanvalidation.OptionalValidatorFactoryBean;

public class ComplexCommonValidator
extends OptionalValidatorFactoryBean {
    private Logger logger = LoggerFactory.getLogger(ComplexCommonValidator.class);

    public void validate(Object target, Errors errors) {
        block6: {
            Validator targetValidator = this.getValidator();
            if (targetValidator == null) break block6;
            if (target instanceof List) {
                for (Object obj : (List)target) {
                    this.validate(obj, errors);
                }
            } else {
                this.processConstraintViolations(targetValidator.validate(target, new Class[0]), errors);
                for (EntityField f : DTOClassInfo.getChildrenFields(target.getClass())) {
                    try {
                        Object children = PropertyUtils.getProperty((Object)target, (String)f.getName());
                        if (children == null) continue;
                        this.validate(children, errors);
                    }
                    catch (Exception e) {
                        if (!this.logger.isErrorEnabled()) continue;
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    protected void processConstraintViolations(Set<ConstraintViolation<Object>> violations, Errors errors) {
        for (ConstraintViolation<Object> violation : violations) {
            String field = this.determineField(violation);
            FieldError fieldError = errors.getFieldError(field);
            if (fieldError != null && fieldError.isBindingFailure()) continue;
            try {
                ConstraintDescriptor cd = violation.getConstraintDescriptor();
                String errorCode = this.determineErrorCode(cd);
                Object[] errorArgs = this.getArgumentsForConstraint(errors.getObjectName(), field, cd);
                if (errors instanceof BindingResult) {
                    BindingResult bindingResult = (BindingResult)errors;
                    String nestedField = bindingResult.getNestedPath() + field;
                    if ("".equals(nestedField)) {
                        String[] errorCodes = bindingResult.resolveMessageCodes(errorCode);
                        bindingResult.addError(new ObjectError(errors.getObjectName(), errorCodes, errorArgs, violation.getMessage()));
                        continue;
                    }
                    Object rejectedValue = this.getRejectedValue(field, violation, bindingResult);
                    String[] errorCodes = bindingResult.resolveMessageCodes(errorCode, field);
                    FieldErrorWithBean fieldErrorWithBean = new FieldErrorWithBean(errors.getObjectName(), nestedField, rejectedValue, false, errorCodes, errorArgs, violation.getMessage());
                    fieldErrorWithBean.setTargetBean(violation.getRootBean());
                    bindingResult.addError((ObjectError)fieldErrorWithBean);
                    continue;
                }
                errors.rejectValue(field, errorCode, errorArgs, violation.getMessage());
            }
            catch (NotReadablePropertyException ex) {
                StringBuilder sb = new StringBuilder(256);
                sb.append("JSR-303 validated property '").append(field);
                sb.append("' does not have a corresponding accessor for Spring data binding - ");
                sb.append("check your DataBinder's configuration (bean property versus direct field access)");
                throw new IllegalStateException(sb.toString(), ex);
            }
        }
    }
}

