/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public final class RequestUtil {
    public static final String X_REQUESTED_WIDTH = "X-Requested-With";
    public static final String XML_HTTP_REQUEST = "XMLHttpRequest";

    private RequestUtil() {
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String xr = request.getHeader(X_REQUESTED_WIDTH);
        return xr != null && XML_HTTP_REQUEST.equalsIgnoreCase(xr);
    }

    public static boolean isAPIRequest(HttpServletRequest request) {
        return request.getRequestURI().contains("/api/");
    }

    public static String getCookieValue(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                if (!cookieName.equals(name)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

