/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.interceptor;

import com.hand.hap.cache.CacheResolve;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.mybatis.common.query.JoinCache;
import com.hand.hap.mybatis.common.query.JoinCode;
import com.hand.hap.mybatis.common.query.JoinLov;
import com.hand.hap.mybatis.common.query.Selection;
import com.hand.hap.mybatis.entity.EntityField;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.hap.system.dto.DTOClassInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class CacheJoinInterceptor
implements Interceptor {
    private Logger logger = LoggerFactory.getLogger(CacheJoinInterceptor.class);
    private Map<String, CacheResolve> cacheJoinType;

    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        if (target instanceof Executor) {
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            if (!mappedStatement.getId().endsWith("selectOptions")) {
                return invocation.proceed();
            }
            Object domain = invocation.getArgs()[1];
            Criteria criteria = null;
            if (domain instanceof MapperMethod.ParamMap) {
                Map m = (Map)domain;
                if (m.containsKey("criteria")) {
                    criteria = (Criteria)((Map)domain).get("criteria");
                }
                if (m.containsKey("dto")) {
                    domain = ((Map)domain).get("dto");
                }
            }
            if (domain instanceof BaseDTO) {
                BaseDTO dtoObj = (BaseDTO)domain;
                if (mappedStatement.getSqlCommandType() == SqlCommandType.SELECT) {
                    Object obj = invocation.proceed();
                    if (!mappedStatement.getId().contains("!")) {
                        this.setFieldValueFromCache(dtoObj, criteria, obj);
                    }
                    return obj;
                }
            }
        }
        return invocation.proceed();
    }

    private void setFieldValueFromCache(BaseDTO parameterObject, Criteria criteria, Object resultObject) throws Exception {
        List<Selection> selectionList;
        criteria = criteria == null ? new Criteria() : criteria;
        List<String> selectFields = null;
        List<String> unSelectFields = criteria.getExcludeSelectFields();
        List<Selection> list = selectionList = CollectionUtils.isEmpty(unSelectFields) ? criteria.getSelectFields() : null;
        if (selectionList != null) {
            selectFields = selectionList.stream().map(v -> v.getField()).collect(Collectors.toList());
        }
        Class<?> clazz = parameterObject.getClass();
        HashMap cacheEntityMap = new HashMap();
        cacheEntityMap.putAll(this.getEntityField(clazz, JoinCache.class, selectFields, unSelectFields));
        cacheEntityMap.putAll(this.getEntityField(clazz, JoinCode.class, selectFields, unSelectFields));
        cacheEntityMap.putAll(this.getEntityField(clazz, JoinLov.class, selectFields, unSelectFields));
        if (!cacheEntityMap.isEmpty() && resultObject instanceof ArrayList) {
            ArrayList resultList = (ArrayList)resultObject;
            for (int i = 0; i < resultList.size(); ++i) {
                this.addCacheColumn(resultList.get(i), cacheEntityMap);
            }
        }
    }

    public Map getEntityField(Class clazz, Class annotation, List<String> selectFields, List<String> unSelectFields) {
        EntityField[] entityFields;
        HashMap cacheColumns = new HashMap();
        for (EntityField entityField : entityFields = DTOClassInfo.getFieldsOfAnnotation(clazz, annotation)) {
            Annotation cache;
            String fieldName = entityField.getName();
            if (entityField.getAnnotation(annotation) instanceof JoinCode) {
                JoinCode code = (JoinCode)entityField.getAnnotation(annotation);
                fieldName = code.joinKey();
            } else if (entityField.getAnnotation(annotation) instanceof JoinCache) {
                cache = (JoinCache)entityField.getAnnotation(annotation);
                fieldName = cache.joinKey();
            } else if (entityField.getAnnotation(annotation) instanceof JoinLov) {
                cache = (JoinLov)entityField.getAnnotation(annotation);
                fieldName = cache.joinKey();
            }
            if (null != unSelectFields && !unSelectFields.isEmpty() ? unSelectFields.contains(fieldName) : null != selectFields && !selectFields.isEmpty() && !selectFields.contains(fieldName)) continue;
            cacheColumns.put(entityField.getName(), entityField.getAnnotation(annotation));
        }
        return cacheColumns;
    }

    private void addCacheColumn(Object resultMap, Map cacheEntityMap) {
        for (Map.Entry<String, Annotation> entry : cacheEntityMap.entrySet()) {
            String cacheKey = (String)entry.getKey();
            try {
                Object columnValue = this.getColumnValueByCache(resultMap, entry);
                if (null == columnValue) continue;
                Field column = resultMap.getClass().getDeclaredField(cacheKey);
                column.setAccessible(true);
                column.set(resultMap, columnValue);
            }
            catch (NoSuchFieldException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private Object getColumnValueByCache(Object resultMap, Map.Entry<String, Annotation> cacheEntity) throws NoSuchFieldException, IllegalAccessException {
        IRequest iRequest = RequestHelper.getCurrentRequest(true);
        String lang = iRequest.getLocale();
        Object result = null;
        CacheResolve cacheResolve = null;
        if (cacheEntity.getValue() instanceof JoinCache) {
            JoinCache joinCache = (JoinCache)cacheEntity.getValue();
            cacheResolve = this.cacheJoinType.get(joinCache.cacheName());
        } else if (cacheEntity.getValue() instanceof JoinCode) {
            cacheResolve = this.cacheJoinType.get("_code");
        } else if (cacheEntity.getValue() instanceof JoinLov) {
            cacheResolve = this.cacheJoinType.get("_lov");
        }
        result = cacheResolve.resolve(cacheEntity.getValue(), resultMap, lang);
        return result;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    public Map<String, CacheResolve> getCacheJoinType() {
        return this.cacheJoinType;
    }

    public void setCacheJoinType(Map<String, CacheResolve> cacheJoinType) {
        this.cacheJoinType = cacheJoinType;
    }
}

