/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.components;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.DatabaseException;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.hap.system.dto.DTOClassInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
public class DatabaseExceptionTranslator {
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource dataSource;
    @Autowired
    private MessageSource messageSource;
    private static Logger logger = LoggerFactory.getLogger(DatabaseExceptionTranslator.class);
    Map<Integer, AbstractDbExceptionHandler> HANDLER_MAPPING_U = new HashMap<Integer, AbstractDbExceptionHandler>();
    Map<Integer, AbstractDbExceptionHandler> HANDLER_MAPPING_N = new HashMap<Integer, AbstractDbExceptionHandler>();
    OracleDbExceptionHandler oracleDbExceptionHandler = new OracleDbExceptionHandler();
    MySqlDbExceptionHandler mySqlDbExceptionHandler = new MySqlDbExceptionHandler();
    SqlServerDbExceptionHandler sqlServerDbExceptionHandler = new SqlServerDbExceptionHandler();

    public DatabaseExceptionTranslator() {
        this.HANDLER_MAPPING_U.put(1, this.oracleDbExceptionHandler);
        this.HANDLER_MAPPING_U.put(1062, this.mySqlDbExceptionHandler);
        this.HANDLER_MAPPING_U.put(2627, this.sqlServerDbExceptionHandler);
        this.HANDLER_MAPPING_U.put(2601, this.sqlServerDbExceptionHandler);
        this.HANDLER_MAPPING_N.put(1364, this.mySqlDbExceptionHandler);
        this.HANDLER_MAPPING_N.put(1048, this.mySqlDbExceptionHandler);
        this.HANDLER_MAPPING_N.put(1400, this.oracleDbExceptionHandler);
        this.HANDLER_MAPPING_N.put(1407, this.oracleDbExceptionHandler);
        this.HANDLER_MAPPING_N.put(515, this.sqlServerDbExceptionHandler);
    }

    public Exception translateException(Exception exception, Object domain) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)exception);
        if (!(rootCause instanceof SQLException)) {
            return exception;
        }
        SQLException sqlException = (SQLException)rootCause;
        int errorCode = sqlException.getErrorCode();
        logger.error("SQLException Error Code: " + errorCode);
        logger.error(sqlException.getMessage(), (Throwable)sqlException);
        try {
            AbstractDbExceptionHandler handler = this.HANDLER_MAPPING_U.get(errorCode);
            if (handler != null) {
                return handler.handleUniqueException(sqlException, domain);
            }
            handler = this.HANDLER_MAPPING_N.get(errorCode);
            if (handler != null) {
                return handler.handleNullException(sqlException, domain);
            }
            logger.warn("can not translate database exception, error code:{}, message:{}", (Object)errorCode, (Object)sqlException.getMessage());
        }
        catch (Exception e) {
            logger.error("error while translate database exception", (Throwable)e);
            return exception;
        }
        return exception;
    }

    private static Locale getLocale() {
        IRequest iRequest = RequestHelper.getCurrentRequest(true);
        if (StringUtils.isEmpty((String)iRequest.getLocale())) {
            iRequest.setLocale("zh_CN");
        }
        String[] ss = iRequest.getLocale().split("_");
        return new Locale(ss[0], ss[1]);
    }

    class SqlServerDbExceptionHandler
    extends AbstractDbExceptionHandler {
        SqlServerDbExceptionHandler() {
        }

        @Override
        public List<String> getRelatedColumns(String indexName) {
            ArrayList<String> columnNames = new ArrayList<String>();
            try (Connection connection = DatabaseExceptionTranslator.this.dataSource.getConnection();
                 PreparedStatement ps = connection.prepareStatement("SELECT  OBJECT_SCHEMA_NAME(ind.object_id) AS SCHEMA_NAME\n      , OBJECT_NAME(ind.object_id) AS TABLE_NAME\n      , col.name AS COLUMN_NAME\nFROM    sys.indexes ind\n        INNER JOIN sys.index_columns ic\n            ON ind.object_id = ic.object_id\n               AND ind.index_id = ic.index_id\n        INNER JOIN sys.columns col\n            ON ic.object_id = col.object_id\n               AND ic.column_id = col.column_id\n        INNER JOIN sys.tables t\n            ON ind.object_id = t.object_id\nWHERE   t.is_ms_shipped = 0 and ind.name =?");){
                ps.setString(1, indexName);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        columnNames.add(rs.getString("COLUMN_NAME"));
                    }
                }
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            return columnNames;
        }

        @Override
        public String getUniqueIndexName(String message) {
            int i1;
            int i0 = message.indexOf(34);
            if (i0 == -1) {
                i0 = message.indexOf(8220);
            }
            if ((i1 = message.indexOf(34, i0 + 1)) == -1) {
                i1 = message.indexOf(8221, i0 + 1);
            }
            String indexName = null;
            try {
                indexName = message.substring(i0 + 1, i1);
                int i2 = indexName.lastIndexOf(46);
                if (i2 >= 0) {
                    return indexName.substring(i2 + 1);
                }
            }
            catch (Exception e0) {
                logger.error("error while extract index name from error message:" + message, (Throwable)e0);
            }
            return indexName;
        }

        @Override
        protected String getNullFieldName(String message) {
            int i0 = message.indexOf("'");
            int i1 = message.indexOf("'", i0 + 1);
            return message.substring(i0 + 1, i1);
        }
    }

    class OracleDbExceptionHandler
    extends AbstractDbExceptionHandler {
        OracleDbExceptionHandler() {
        }

        @Override
        public List<String> getRelatedColumns(String indexName) {
            ArrayList<String> columnNames = new ArrayList<String>();
            try (Connection connection = DatabaseExceptionTranslator.this.dataSource.getConnection();
                 PreparedStatement ps = connection.prepareStatement("select * from user_ind_columns where index_name=?");){
                ps.setString(1, indexName);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        columnNames.add(rs.getString("COLUMN_NAME"));
                    }
                }
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            return columnNames;
        }

        @Override
        public String getUniqueIndexName(String message) {
            int i0 = message.lastIndexOf(40);
            int i1 = message.lastIndexOf(41);
            String indexName = null;
            try {
                indexName = message.substring(i0 + 1, i1);
                int i2 = indexName.lastIndexOf(46);
                if (i2 >= 0) {
                    return indexName.substring(i2 + 1);
                }
            }
            catch (Exception e0) {
                logger.error("error while extract index name from error message:" + message, (Throwable)e0);
            }
            return indexName;
        }

        @Override
        protected String getNullFieldName(String message) {
            int i0 = message.lastIndexOf(34);
            int i1 = message.lastIndexOf(34, i0 - 1);
            return message.substring(i1 + 1, i0);
        }
    }

    class MySqlDbExceptionHandler
    extends AbstractDbExceptionHandler {
        MySqlDbExceptionHandler() {
        }

        @Override
        public List<String> getRelatedColumns(String indexName) {
            ArrayList<String> columnNames = new ArrayList<String>();
            try (Connection connection = DatabaseExceptionTranslator.this.dataSource.getConnection();
                 PreparedStatement ps = connection.prepareStatement("select * from INFORMATION_SCHEMA.STATISTICS s where s.TABLE_SCHEMA=? and s.INDEX_NAME=?");){
                ps.setString(1, connection.getCatalog());
                ps.setString(2, indexName);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        columnNames.add(rs.getString("COLUMN_NAME"));
                    }
                }
            }
            catch (SQLException e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
            }
            return columnNames;
        }

        @Override
        public String getUniqueIndexName(String message) {
            int i0 = message.indexOf(39);
            int i1 = message.lastIndexOf("' for key '");
            String value = null;
            String indexName = null;
            try {
                value = message.substring(i0 + 1, i1);
                indexName = message.substring(i1 + 11, message.length() - 1);
            }
            catch (Exception e0) {
                logger.error("error while extract index name from error message:" + message, (Throwable)e0);
            }
            return indexName;
        }

        @Override
        protected String getNullFieldName(String message) {
            int i0 = message.indexOf("'");
            int i1 = message.indexOf("'", i0 + 1);
            return message.substring(i0 + 1, i1);
        }
    }

    abstract class AbstractDbExceptionHandler {
        AbstractDbExceptionHandler() {
        }

        public abstract List<String> getRelatedColumns(String var1);

        protected abstract String getUniqueIndexName(String var1);

        protected abstract String getNullFieldName(String var1);

        public Exception handleUniqueException(SQLException sqlException, Object domain) throws Exception {
            String indexName = this.getUniqueIndexName(sqlException.getMessage());
            List<String> columnNames = this.getRelatedColumns(indexName);
            Class<?> clazz = domain.getClass();
            Locale locale = DatabaseExceptionTranslator.getLocale();
            StringBuilder sb = new StringBuilder();
            sb.append(DatabaseExceptionTranslator.this.messageSource.getMessage("hap.error.uniqueexception", null, locale));
            if (!(domain instanceof BaseDTO)) {
                sb.append(" ; ").append(sqlException.getMessage());
                return new DatabaseException(indexName + ":" + sqlException.getErrorCode(), sb.toString());
            }
            for (String cn : columnNames) {
                String field = DTOClassInfo.underLineToCamel(cn);
                String value0 = BeanUtils.getProperty((Object)domain, (String)field);
                sb.append(" ; ").append(DatabaseExceptionTranslator.this.messageSource.getMessage(StringUtils.lowerCase((String)(clazz.getSimpleName() + "." + field)), null, locale));
                sb.append(" : ").append(value0);
            }
            return new DatabaseException(indexName + ":" + sqlException.getErrorCode(), sb.toString());
        }

        public Exception handleNullException(SQLException sqlException, Object domain) throws Exception {
            String columnName = this.getNullFieldName(sqlException.getMessage());
            Class<?> clazz = domain.getClass();
            Locale locale = DatabaseExceptionTranslator.getLocale();
            StringBuilder sb = new StringBuilder();
            sb.append(DatabaseExceptionTranslator.this.messageSource.getMessage("hap.error.nullexception", null, locale));
            if (!(domain instanceof BaseDTO)) {
                sb.append(" ; ").append(sqlException.getMessage());
                return new DatabaseException(columnName + ":" + sqlException.getErrorCode(), sb.toString());
            }
            String field = DTOClassInfo.underLineToCamel(columnName);
            sb.append(" : ").append(DatabaseExceptionTranslator.this.messageSource.getMessage(StringUtils.lowerCase((String)(clazz.getSimpleName() + "." + field)), null, locale));
            return new DatabaseException(columnName + ":" + sqlException.getErrorCode(), sb.toString());
        }
    }
}

