/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.components;

import com.hand.hap.core.AppContextInitListener;
import com.hand.hap.core.util.TimeZoneUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ConverterRegister
implements AppContextInitListener {
    @Override
    public void contextInitialized(ApplicationContext applicationContext) {
        ConvertUtils.register((Converter)new Converter(){

            public Object convert(Class type, Object value) {
                if (value instanceof Date) {
                    return value;
                }
                if (value instanceof Calendar) {
                    return ((Calendar)value).getTime();
                }
                if (value == null) {
                    return null;
                }
                if (value instanceof Long) {
                    Long longObj = (Long)value;
                    return type.cast(new Date(longObj));
                }
                if (value instanceof String) {
                    String str = StringUtils.trim((String)((String)value));
                    if (StringUtils.isEmpty((String)str)) {
                        return null;
                    }
                    try {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                        format.setTimeZone(TimeZoneUtil.getTimeZone());
                        return format.parse(str);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        }, Date.class);
    }
}

