/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.components;

import com.hand.hap.core.exception.TokenException;
import com.hand.hap.core.interceptor.SecurityTokenInterceptor;
import com.hand.hap.security.TokenUtils;
import com.hand.hap.system.dto.BaseDTO;
import java.util.Collection;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CheckTokenAspect {
    @Value(value="${sys.security.token.validate:true}")
    private boolean sysSecurityTokenValidate;

    @Pointcut(value="execution(* *..*Controller.*(..))")
    public void pointCut() {
    }

    @Before(value="pointCut()")
    public void checkBeanValid(JoinPoint joinPoint) throws TokenException {
        if (this.sysSecurityTokenValidate) {
            Object[] args = joinPoint.getArgs();
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof BaseDTO) {
                    this.checkToken(args[i]);
                    continue;
                }
                if (!(args[i] instanceof Collection)) continue;
                for (Object o : (Collection)args[i]) {
                    if (!(o instanceof BaseDTO)) continue;
                    this.checkToken(o);
                }
            }
        }
    }

    private void checkToken(Object obj) throws TokenException {
        BaseDTO baseDto = (BaseDTO)obj;
        boolean check = "update".equals(baseDto.get__status());
        if (check) {
            TokenUtils.checkToken(SecurityTokenInterceptor.LOCAL_SECURITY_KEY.get(), baseDto);
        }
    }
}

