/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.attachment.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.attachment.dto.Attachment;
import com.hand.hap.attachment.dto.SysFile;
import com.hand.hap.attachment.exception.UniqueFileMutiException;
import com.hand.hap.attachment.mapper.AttachmentMapper;
import com.hand.hap.attachment.mapper.SysFileMapper;
import com.hand.hap.attachment.service.IAttachCategoryService;
import com.hand.hap.attachment.service.ISysFileService;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.core.util.FormatUtil;
import com.hand.hap.core.util.UploadUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysFileServiceImpl
implements ISysFileService {
    private static final int NO_PAGE = -1;
    private static final int PAGE_NO = 1;
    public static final int H_WIDTH = 480;
    public static final int H_HEIGHT = 480;
    public static final int M_WIDTH = 360;
    public static final int M_HEIGHT = 360;
    public static final int L_WIDTH = 78;
    public static final int L_HEIGHT = 78;
    @Autowired
    private SysFileMapper sysFileMapper;
    @Autowired
    private AttachmentMapper attachmentMapper;
    @Autowired
    private IAttachCategoryService iAttachCategoryService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SysFile insert(IRequest requestContext, @StdWho SysFile file) {
        this.sysFileMapper.insertSelective(file);
        return file;
    }

    @Override
    public SysFile delete(IRequest requestContext, SysFile file) {
        SysFile sysFile = (SysFile)this.sysFileMapper.selectByPrimaryKey(file.getFileId());
        if (sysFile != null) {
            this.sysFileMapper.deleteByPrimaryKey(file);
        } else {
            sysFile = file;
        }
        UploadUtil.deleteFile(sysFile.getFilePath());
        return sysFile;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<SysFile> selectFiles(IRequest requestContext, SysFile file, int page, int pagesize) {
        if (pagesize > -1) {
            PageHelper.startPage(page, pagesize);
        }
        return this.sysFileMapper.select(file);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SysFile insertFileAndAttach(IRequest requestContext, Attachment attach, @StdWho SysFile file) {
        Attachment params = new Attachment();
        params.setSourceType(attach.getSourceType());
        params.setSourceKey(attach.getSourceKey());
        params = this.attachmentMapper.selectAttachment(params);
        if (params == null) {
            attach.setStartActiveDate(new Date());
            attach.setEndActiveDate(new Date());
            try {
                this.attachmentMapper.insertSelective(attach);
                params = attach;
            }
            catch (Exception e) {
                params = new Attachment();
                params.setSourceType(attach.getSourceType());
                params.setSourceKey(attach.getSourceKey());
                params = this.attachmentMapper.selectAttachment(params);
            }
        }
        file.setAttachmentId(params.getAttachmentId());
        ((ISysFileService)this.self()).insert(requestContext, file);
        return file;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public SysFile selectByPrimaryKey(IRequest requestContext, Long fileId) {
        return (SysFile)this.sysFileMapper.selectByPrimaryKey(fileId);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<SysFile> selectFilesByTypeAndKey(IRequest requestContext, String sourceType, String sourceKey) {
        if (StringUtils.isBlank((CharSequence)sourceType) || sourceKey == null) {
            return null;
        }
        Attachment attachment = new Attachment();
        attachment.setSourceKey(sourceKey);
        attachment.setSourceType(sourceType);
        Attachment attach = this.attachmentMapper.selectAttachment(attachment);
        if (attach != null) {
            SysFile file = new SysFile();
            file.setAttachmentId(attach.getAttachmentId());
            return ((ISysFileService)this.self()).selectFiles(requestContext, file, 1, -1);
        }
        return null;
    }

    @Override
    public void removeFiles(IRequest requestContext, List<SysFile> sysFiles) {
        for (SysFile file : sysFiles) {
            ((ISysFileService)this.self()).delete(requestContext, file);
        }
    }

    @Override
    public List<SysFile> selectFilesByCategoryId(IRequest requestContext, SysFile file, Long categoryId, int page, int pagesize) {
        Attachment params = new Attachment(categoryId);
        List<Attachment> attachments = this.attachmentMapper.select(params);
        if (categoryId == null || attachments == null || attachments.isEmpty()) {
            return new LinkedList<SysFile>();
        }
        ArrayList<Long> attachmentIds = new ArrayList<Long>();
        for (Attachment a : attachments) {
            attachmentIds.add(a.getAttachmentId());
        }
        PageHelper.startPage(page, pagesize);
        return this.sysFileMapper.selectFilesByAttachIds(attachmentIds, file);
    }

    @Override
    public List<SysFile> selectFilesBySourceTypeAndSourceKey(IRequest requestContext, String type, String key) {
        List<SysFile> result = new ArrayList<SysFile>();
        if (type != null && key != null) {
            result = this.sysFileMapper.queryfiles(type, key);
            result.forEach(a -> a.setFileSizeDesc(FormatUtil.formatFileSize(a.getFileSize())));
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SysFile updateOrInsertFile(IRequest requestContext, @StdWho Attachment attach, @StdWho SysFile file) throws UniqueFileMutiException {
        Attachment params = new Attachment();
        params.setSourceType(attach.getSourceType());
        params.setSourceKey(attach.getSourceKey());
        params = this.attachmentMapper.selectAttachment(params);
        if (params == null) {
            return ((ISysFileService)this.self()).insertFileAndAttach(requestContext, attach, file);
        }
        SysFile sysParams = new SysFile();
        sysParams.setAttachmentId(params.getAttachmentId());
        List<SysFile> sysFiles = this.sysFileMapper.select(sysParams);
        if (sysFiles.isEmpty()) {
            file.setAttachmentId(params.getAttachmentId());
            this.sysFileMapper.insertSelective(file);
            return file;
        }
        if (sysFiles.size() > 1) {
            throw new UniqueFileMutiException();
        }
        String path = sysFiles.get(0).getFilePath();
        SysFile sysFile = sysFiles.get(0);
        sysFile.setFileName(file.getFileName());
        sysFile.setFilePath(file.getFilePath());
        sysFile.setFileSize(file.getFileSize());
        sysFile.setUploadDate(file.getUploadDate());
        sysFile.setLastUpdatedBy(file.getLastUpdatedBy());
        sysFile.setFileType(file.getFileType());
        this.sysFileMapper.updateByPrimaryKeySelective(sysFile);
        UploadUtil.deleteFile(path);
        return sysFile;
    }

    @Override
    public List<SysFile> selectByIds(IRequest requestContext, List<String> fileIds) {
        if (fileIds == null || fileIds.isEmpty()) {
            return null;
        }
        return this.sysFileMapper.selectFilesByIds(fileIds);
    }

    @Override
    public List<SysFile> selectFilesByTypeAndKey(IRequest requestContext, String sourceType, Long sourceKey) {
        return ((ISysFileService)this.self()).selectFilesByTypeAndKey(requestContext, sourceType, sourceKey.toString());
    }

    @Override
    public SysFile deleteImage(IRequest requestContext, SysFile file) {
        SysFile sysFile = (SysFile)this.sysFileMapper.selectByPrimaryKey(file.getFileId());
        if (sysFile != null) {
            this.sysFileMapper.deleteByPrimaryKey(file);
        } else {
            sysFile = file;
        }
        String filePath = sysFile.getFilePath();
        UploadUtil.deleteFile(filePath + "_" + 480 + "_" + 480);
        UploadUtil.deleteFile(filePath + "_" + 360 + "_" + 360);
        UploadUtil.deleteFile(filePath + "_" + 78 + "_" + 78);
        UploadUtil.deleteFile(sysFile.getFilePath());
        return sysFile;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<SysFile> queryFilesByTypeAndKey(IRequest requestContext, String sourceType, String sourceKey) {
        return this.sysFileMapper.queryfiles(sourceType, sourceKey);
    }

    @Override
    public void deletefiles(IRequest requestContext, SysFile file) {
        ((ISysFileService)this.self()).delete(requestContext, file);
    }
}

