/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.api.gateway.service.impl;

import com.hand.hap.api.gateway.dto.ApiServer;
import com.hand.hap.api.gateway.service.IApiInvokeService;
import com.hand.hap.api.gateway.service.impl.HttpRequestAuthorization;
import com.hand.hap.core.ProxySelf;
import com.hand.hap.core.util.FreemarkerUtil;
import com.hand.hap.intergration.exception.HapApiException;
import com.hand.hap.intergration.util.JSONAndMap;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Service
public class ApiSoapInvokeServiceImpl
implements IApiInvokeService,
ProxySelf<IApiInvokeService> {
    private static final Logger logger = LoggerFactory.getLogger(ApiSoapInvokeServiceImpl.class);
    @Autowired
    HttpRequestAuthorization httpRequestAuthorization;

    @Override
    public String serverType() {
        return "SOAP";
    }

    @Override
    public Object invoke(ApiServer server, JSONObject inbound) throws Exception {
        logger.info("inbound:{}", (Object)inbound);
        String xml = this.translateSendXml(server, inbound);
        String data = ((IApiInvokeService)this.self()).apiInvoke(server, xml);
        return this.translateReponseData(data);
    }

    @Override
    public String apiInvoke(ApiServer server, String parameter) throws Exception {
        return this.sendRequest(server, parameter);
    }

    private String translateSendXml(ApiServer server, JSONObject inbound) throws Exception {
        Document document;
        String xml = "";
        if (inbound != null) {
            xml = server.getElementFormDefault().equals("qualified") ? JSONAndMap.jsonToXml(inbound.toString(), "hap:") : JSONAndMap.jsonToXml(inbound.toString(), null);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)server.getApiInterface().getInterfaceUrl(), (Object)xml);
        xml = JSONAndMap.jsonToXml(jsonObject.toString(), "hap:");
        HashMap<String, String> dataMap = new HashMap<String, String>(10);
        dataMap.put("namespace", server.getNamespace());
        dataMap.put("soapBody", xml);
        if (server.getApiInterface().getSoapVersion().equals("SOAP11")) {
            dataMap.put("soapNamespace", "http://schemas.xmlsoap.org/soap/envelope/");
        } else {
            dataMap.put("soapNamespace", "http://www.w3.org/2003/05/soap-envelope");
        }
        if (server.getWssPasswordType().equals("PasswordText")) {
            document = this.getDocument();
            WSSecUsernameToken ut = new WSSecUsernameToken();
            ut.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            ut.setUserInfo(server.getUsername(), server.getPassword());
            ut.prepare(document);
            dataMap.put("wssSecurity", this.getSecurityStr(ut.getUsernameTokenElement()));
        } else if (server.getWssPasswordType().equals("PasswordDigest")) {
            document = this.getDocument();
            WSSecUsernameToken ut = new WSSecUsernameToken();
            ut.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
            ut.setUserInfo(server.getUsername(), server.getPassword());
            ut.addCreated();
            ut.addNonce();
            ut.prepare(document);
            dataMap.put("wssSecurity", this.getSecurityStr(ut.getUsernameTokenElement()));
        }
        try {
            xml = FreemarkerUtil.translateData("<soap:Envelope xmlns:soap=\"${soapNamespace}\" xmlns:hap=\"${namespace}\">\n<soap:Header>\n ${wssSecurity} </soap:Header>\n  <soap:Body>\n  ${soapBody} \n</soap:Body>\n</soap:Envelope>", dataMap);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new HapApiException(e.getMessage(), "Failed to generate the encoding, process variable fail");
        }
        return xml;
    }

    private JSONObject translateReponseData(String data) throws Exception {
        JSONObject jsonObject;
        try {
            Map map = JSONAndMap.xml2map(data);
            jsonObject = JSONObject.fromObject((Object)map);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new HapApiException("API_SYSTEM_EXCEPTION", "error.format_xmlToMap");
        }
        return jsonObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSecurityStr(Element ut) {
        try (StringWriter writer = new StringWriter();){
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(ut), new StreamResult(writer));
            String string = "<wsse:Security xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" soap:mustUnderstand=\"1\">" + writer.getBuffer().toString() + "</wsse:Security>";
            return string;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private Document getDocument() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        return dbf.newDocumentBuilder().newDocument();
    }

    private String sendRequest(ApiServer server, String xml) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String requestUrl = this.translateRequestUrl(server);
        StringEntity entiy = new StringEntity(xml, "UTF-8");
        try {
            HttpPost httpPost = new HttpPost(requestUrl);
            httpPost.setEntity((HttpEntity)entiy);
            this.httpRequestAuthorization.setHttpRequestAuthorization((HttpRequest)httpPost, server, true);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() == 401 && "OAUTH2".equalsIgnoreCase(server.getAuthType())) {
                this.httpRequestAuthorization.updateToken((HttpRequest)httpPost, server);
                response = httpclient.execute((HttpUriRequest)httpPost);
            }
            String data = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new HapApiException("API_THIRD_PARTY_REQUEST_" + response.getStatusLine().getStatusCode(), data);
            }
            String string = data;
            return string;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            httpclient.close();
        }
    }

    private String translateRequestUrl(ApiServer server) {
        String requestUrl = "";
        if (server.getDomainUrl() != null) {
            requestUrl = requestUrl + server.getDomainUrl();
        }
        return requestUrl;
    }
}

