/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.api.gateway.service.impl;

import com.hand.hap.api.gateway.dto.ApiInterface;
import com.hand.hap.api.gateway.dto.ApiServer;
import com.hand.hap.api.gateway.mapper.ApiInterfaceMapper;
import com.hand.hap.api.gateway.mapper.ApiServerMapper;
import com.hand.hap.api.gateway.service.IApiImportService;
import com.hand.hap.api.gateway.service.IApiServerService;
import com.hand.hap.cache.impl.ApiServerCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.intergration.service.IHapAuthenticationService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApiServerServiceImpl
extends BaseServiceImpl<ApiServer>
implements IApiServerService {
    @Autowired
    private ApiServerMapper serverMapper;
    @Autowired
    private ApiInterfaceMapper interfaceMapper;
    @Resource(name="restImportServer")
    private IApiImportService restImportServer;
    @Resource(name="soapImportServer")
    private IApiImportService soapImportServer;
    @Autowired
    private ApiServerCache serverCache;
    @Autowired
    private IHapAuthenticationService authenticationService;

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public List<ApiServer> selectByCodes(IRequest request, List<String> codeList) {
        return this.serverMapper.selectByCodes(codeList);
    }

    @Override
    public ApiServer importServer(IRequest request, ApiServer srServer) {
        String importUrl = srServer.getImportUrl();
        String[] s = importUrl.split("\\?");
        srServer = s.length == 2 && "wsdl".equals(s[1].toLowerCase()) ? this.soapImportServer.importServer(srServer) : this.restImportServer.importServer(srServer);
        return srServer;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<ApiServer> batchUpdate(IRequest request, List<ApiServer> servers) {
        for (ApiServer server : servers) {
            if (server.getServerId() == null) {
                ((IApiServerService)this.self()).insertServer(server);
                continue;
            }
            ((IApiServerService)this.self()).updateServer(request, server);
        }
        return servers;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiServer insertServer(ApiServer server) {
        this.serverMapper.insertSelective(server);
        if (server.getInterfaces() != null) {
            this.processInterfaces(server);
        }
        this.serverCache.reload(server);
        return server;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiServer updateServer(IRequest request, @StdWho ApiServer server) {
        ApiServer preServer = this.selectByPrimaryKey(request, server);
        int count = this.serverMapper.updateByPrimaryKey(server);
        this.checkOvn(count, server);
        if (server.getInterfaces() != null) {
            this.processInterfaces(server);
        }
        this.serverCache.remove(preServer);
        this.serverCache.reload(server);
        if ("OAUTH2".equalsIgnoreCase(server.getAuthType())) {
            this.authenticationService.removeToken(server);
        }
        return server;
    }

    private void processInterfaces(ApiServer server) {
        for (ApiInterface srInterface : server.getInterfaces()) {
            if (srInterface.getInterfaceId() == null) {
                srInterface.setServerId(server.getServerId());
                this.interfaceMapper.insertSelective(srInterface);
                continue;
            }
            int count = this.interfaceMapper.updateByPrimaryKey(srInterface);
            this.checkOvn(count, srInterface);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(List<ApiServer> servers) {
        for (ApiServer server : servers) {
            this.interfaceMapper.removeByServerId(server.getServerId());
            int count = this.serverMapper.deleteByPrimaryKey(server);
            this.checkOvn(count, server);
            this.serverCache.remove(server);
        }
        return servers.size();
    }

    @Override
    public ApiServer getByMappingUrl(String serverUrl, String interfaceUrl) {
        return this.serverCache.getValue(serverUrl, interfaceUrl);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public List<ApiServer> selectNotExistsServerByApp(Map<String, Object> params) {
        return this.serverMapper.selectNotExistsServerByApp(params);
    }
}

