/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.util;

import com.hand.hap.activiti.core.IActivitiConstants;
import com.hand.hap.hr.dto.Employee;
import com.hand.hap.hr.dto.Position;
import com.hand.hap.mybatis.util.StringUtil;
import java.util.Date;
import java.util.List;
import org.activiti.bpmn.model.FormProperty;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.identity.Group;
import org.activiti.engine.impl.persistence.entity.GroupEntity;
import org.activiti.engine.impl.persistence.entity.GroupEntityImpl;
import org.activiti.engine.impl.persistence.entity.UserEntity;
import org.activiti.engine.impl.persistence.entity.UserEntityImpl;
import org.apache.commons.lang.StringUtils;

public class ActivitiUtils
implements IActivitiConstants {
    public static UserEntity toActivitiUser(Employee emp) {
        UserEntityImpl entity = new UserEntityImpl();
        if (emp == null) {
            return entity;
        }
        entity.setId(emp.getEmployeeCode());
        String empName = emp.getName();
        entity.setFirstName(StringUtils.defaultIfEmpty((String)empName, (String)"UNKNOWN"));
        entity.setLastName("");
        entity.setEmail(emp.getEmail());
        entity.setRevision(1);
        return entity;
    }

    public static GroupEntity toActivitiGroup(Position position) {
        GroupEntityImpl groupEntity = new GroupEntityImpl();
        if (position == null) {
            return groupEntity;
        }
        groupEntity.setRevision(1);
        groupEntity.setId(position.getPositionCode());
        groupEntity.setName(position.getName());
        groupEntity.setType("assignment");
        return groupEntity;
    }

    public static List<Group> toActivitiGroups(List<String> groupIds) {
        return null;
    }

    public static FormProperty getFormPropertyById(List<FormProperty> properties, String id) {
        FormProperty formProperty = null;
        for (FormProperty property : properties) {
            if (!id.equalsIgnoreCase(property.getId())) continue;
            formProperty = property;
            break;
        }
        return formProperty;
    }

    public static boolean isAddApproveChain(UserTask userTask) {
        FormProperty approvalStrategy = ActivitiUtils.getFormPropertyById(userTask.getFormProperties(), "APPROVAL_STRATEGY");
        FormProperty approvalCandidate = ActivitiUtils.getFormPropertyById(userTask.getFormProperties(), "APPROVAL_CANDIDATE_RULE");
        if (approvalStrategy != null && "WFL_CHAIN".equalsIgnoreCase(approvalStrategy.getName())) {
            return true;
        }
        if (approvalStrategy == null && approvalCandidate == null) {
            return true;
        }
        return approvalStrategy != null && StringUtil.isEmpty(approvalStrategy.getName()) && approvalCandidate != null && approvalCandidate.getFormValues() == null;
    }

    public static boolean isEnabledRevoke(UserTask userTask) {
        FormProperty revokeEnableFlag = ActivitiUtils.getFormPropertyById(userTask.getFormProperties(), "ACT_REVOKE_ENABLE_FLAG");
        return revokeEnableFlag == null || !"N".equalsIgnoreCase(revokeEnableFlag.getName());
    }

    public static boolean isUseNewModelEditor(UserTask task) {
        FormProperty approvalCandidate = ActivitiUtils.getFormPropertyById(task.getFormProperties(), "APPROVAL_CANDIDATE_RULE");
        return approvalCandidate != null && approvalCandidate.getFormValues() != null;
    }

    public static Long secondsBetweenDate(Date firstDate, Date secondDate) {
        Long interval = (secondDate.getTime() - firstDate.getTime()) / 1000L;
        return interval;
    }
}

