/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.listeners;

import com.hand.hap.account.dto.User;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.activiti.core.IActivitiConstants;
import com.hand.hap.core.AppContextInitListener;
import com.hand.hap.system.dto.SysPreferences;
import com.hand.hap.system.service.ISysPreferencesService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class AutoDelegateListener
implements TaskListener,
IActivitiConstants,
AppContextInitListener {
    @Autowired
    private ISysPreferencesService preferencesService;
    @Autowired
    private IUserService userService;
    private TaskService taskService;

    public void notify(DelegateTask delegateTask) {
        TaskEntity task = (TaskEntity)delegateTask;
        String taskId = task.getId();
        String delegateName = this.autoDelegate(task);
        if (StringUtils.isNotEmpty((String)delegateName)) {
            Authentication.setAuthenticatedUserId(null);
            this.taskService.addComment(taskId, task.getProcessInstanceId(), "action", "AUTO_DELEGATE");
            this.taskService.addComment(taskId, task.getProcessInstanceId(), "comment", task.getAssignee() + " \u8f6c\u4ea4\u7ed9 " + delegateName);
            this.taskService.setAssignee(taskId, delegateName);
        }
    }

    private String autoDelegate(TaskEntity task) {
        if (StringUtils.isEmpty((String)task.getAssignee())) {
            return null;
        }
        List<User> users = this.userService.selectUserNameByEmployeeCode(task.getAssignee());
        if (CollectionUtils.isEmpty(users)) {
            return null;
        }
        User user = users.get(0);
        SysPreferences preferences = this.preferencesService.selectUserPreference("autoDelegate", user.getUserId());
        if (preferences == null) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)preferences.getPreferencesValue())) {
            if (task.getAssignee().equalsIgnoreCase(preferences.getPreferencesValue())) {
                return null;
            }
            SysPreferences startDate = this.preferencesService.selectUserPreference("deliverStartDate", user.getUserId());
            SysPreferences endDate = this.preferencesService.selectUserPreference("deliverEndDate", user.getUserId());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date end;
                if (startDate == null || StringUtils.isEmpty((String)startDate.getPreferencesValue())) {
                    return null;
                }
                Date start = sdf.parse(startDate.getPreferencesValue());
                if (start.getTime() > System.currentTimeMillis()) {
                    return null;
                }
                if (endDate != null && StringUtils.isNotEmpty((String)endDate.getPreferencesValue()) && (end = sdf.parse(endDate.getPreferencesValue())).getTime() < System.currentTimeMillis()) {
                    return null;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
        return preferences.getPreferencesValue();
    }

    @Override
    public void contextInitialized(ApplicationContext applicationContext) {
        this.taskService = (TaskService)applicationContext.getBean(TaskService.class);
    }
}

