/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.custom;

import com.hand.hap.activiti.approval.dto.ApproveStrategy;
import com.hand.hap.activiti.approval.mapper.ApproveStrategyMapper;
import com.hand.hap.activiti.core.IActivitiConstants;
import com.hand.hap.activiti.listeners.AutoDelegateListener;
import com.hand.hap.activiti.listeners.NotificationListener;
import com.hand.hap.activiti.listeners.TaskCreateNotificationListener;
import com.hand.hap.activiti.listeners.TaskEndNotificationListener;
import com.hand.hap.activiti.util.ActivitiUtils;
import com.hand.hap.mybatis.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.FormProperty;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.Task;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.factory.ActivityBehaviorFactory;
import org.activiti.engine.impl.bpmn.parser.handler.UserTaskParseHandler;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomUserTaskParseHandler
extends UserTaskParseHandler
implements IActivitiConstants {
    @Autowired
    private NotificationListener notificationListener;
    @Autowired
    private AutoDelegateListener autoDelegateListener;
    @Autowired
    private TaskCreateNotificationListener taskCreateNotificationListener;
    @Autowired
    private TaskEndNotificationListener taskEndNotificationListener;
    @Autowired
    private ActivityBehaviorFactory activityBehaviorFactory;
    @Autowired
    private ApproveStrategyMapper strategyMapper;

    protected void executeParse(BpmnParse bpmnParse, UserTask userTask) {
        super.executeParse(bpmnParse, userTask);
        ActivitiListener deliverlistener = new ActivitiListener();
        deliverlistener.setEvent("create");
        deliverlistener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_INSTANCE);
        deliverlistener.setInstance((Object)this.autoDelegateListener);
        userTask.getTaskListeners().add(0, deliverlistener);
        ActivitiListener listener = new ActivitiListener();
        listener.setEvent("all");
        listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_INSTANCE);
        listener.setInstance((Object)this.notificationListener);
        userTask.getTaskListeners().add(listener);
        ActivitiListener listenerCreate = new ActivitiListener();
        listenerCreate.setEvent("create");
        listenerCreate.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_INSTANCE);
        listenerCreate.setOnTransaction("committed");
        listenerCreate.setInstance((Object)this.taskCreateNotificationListener);
        userTask.getTaskListeners().add(listenerCreate);
        ActivitiListener listenerEnd = new ActivitiListener();
        listenerEnd.setEvent("delete");
        listenerEnd.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_INSTANCE);
        listenerEnd.setOnTransaction("committed");
        listenerEnd.setInstance((Object)this.taskEndNotificationListener);
        userTask.getTaskListeners().add(listenerEnd);
        if (ActivitiUtils.isAddApproveChain(userTask)) {
            FlowNode flowNode = this.addApproveChain(bpmnParse, userTask);
            this.autoEnd(bpmnParse, flowNode);
        } else {
            this.multiInstance(userTask);
            this.autoEnd(bpmnParse, (FlowNode)userTask);
        }
    }

    private FlowNode addApproveChain(BpmnParse bpmnParse, UserTask userTask) {
        List outgoings = userTask.getOutgoingFlows();
        if (outgoings.size() != 1) {
            return userTask;
        }
        ActivitiListener executeListener = new ActivitiListener();
        executeListener.setEvent("start");
        executeListener.setImplementationType("expression");
        executeListener.setImplementation("#{hapApproveChain.onTaskStart(execution)}");
        userTask.getExecutionListeners().add(executeListener);
        SequenceFlow s0 = (SequenceFlow)outgoings.get(0);
        ExclusiveGateway exclusiveGateway = new ExclusiveGateway();
        exclusiveGateway.setId("eg_auto_" + UUID.randomUUID().toString());
        exclusiveGateway.setParentContainer(userTask.getParentContainer());
        exclusiveGateway.setBehavior((Object)this.activityBehaviorFactory.createExclusiveGatewayActivityBehavior(exclusiveGateway));
        SequenceFlow s1 = new SequenceFlow();
        s1.setValues(s0);
        s1.setWaypoints(s0.getWaypoints());
        s1.setSourceFlowElement((FlowElement)userTask);
        s1.setTargetFlowElement((FlowElement)exclusiveGateway);
        outgoings.remove(s0);
        outgoings.add(s1);
        exclusiveGateway.getIncomingFlows().add(s1);
        SequenceFlow s2 = new SequenceFlow();
        s2.setId("sf_auto_" + UUID.randomUUID().toString());
        s2.setSourceRef(exclusiveGateway.getId());
        s2.setSourceFlowElement((FlowElement)exclusiveGateway);
        s2.setTargetRef(userTask.getId());
        s2.setTargetFlowElement((FlowElement)userTask);
        s2.setConditionExpression("${hapApproveChain.execute(execution,'" + userTask.getId() + "')=='Y'}");
        userTask.getIncomingFlows().add(s2);
        exclusiveGateway.getOutgoingFlows().add(s2);
        SequenceFlow defaultSeq = new SequenceFlow();
        defaultSeq.setId("sf_auto_" + UUID.randomUUID().toString());
        if (s0.getTargetFlowElement() instanceof FlowNode) {
            FlowNode targetTskOfs0 = (FlowNode)s0.getTargetFlowElement();
            targetTskOfs0.getIncomingFlows().remove(s0);
            targetTskOfs0.getIncomingFlows().add(defaultSeq);
        }
        defaultSeq.setSourceRef(exclusiveGateway.getId());
        defaultSeq.setSourceFlowElement((FlowElement)exclusiveGateway);
        defaultSeq.setTargetFlowElement(s0.getTargetFlowElement());
        defaultSeq.setTargetRef(s0.getTargetRef());
        exclusiveGateway.getOutgoingFlows().add(0, defaultSeq);
        exclusiveGateway.setDefaultFlow(defaultSeq.getId());
        bpmnParse.getSequenceFlows().put(s1.getId(), s1);
        bpmnParse.getSequenceFlows().put(s2.getId(), s2);
        bpmnParse.getSequenceFlows().put(defaultSeq.getId(), defaultSeq);
        return exclusiveGateway;
    }

    private void autoEnd(BpmnParse bpmnParse, FlowNode userTask) {
        List outgoings = userTask.getOutgoingFlows();
        if (outgoings == null || outgoings.isEmpty()) {
            return;
        }
        SequenceFlow s0 = (SequenceFlow)outgoings.get(0);
        FlowElement nextNode = s0.getTargetFlowElement();
        if (nextNode instanceof Task) {
            ExclusiveGateway exclusiveGateway = new ExclusiveGateway();
            exclusiveGateway.setId("eg_auto_" + UUID.randomUUID().toString());
            exclusiveGateway.setParentContainer(userTask.getParentContainer());
            exclusiveGateway.setBehavior((Object)this.activityBehaviorFactory.createExclusiveGatewayActivityBehavior(exclusiveGateway));
            outgoings.remove(s0);
            SequenceFlow s1 = new SequenceFlow();
            outgoings.add(s1);
            s1.setValues(s0);
            s1.setSourceFlowElement((FlowElement)userTask);
            s1.setTargetFlowElement((FlowElement)exclusiveGateway);
            s1.setWaypoints(s0.getWaypoints());
            exclusiveGateway.setIncomingFlows(Arrays.asList(s1));
            SequenceFlow s2 = new SequenceFlow();
            s2.setId("sf_auto_" + UUID.randomUUID().toString());
            s2.setSourceFlowElement((FlowElement)exclusiveGateway);
            s2.setSourceRef(exclusiveGateway.getId());
            s2.setTargetFlowElement(nextNode);
            s2.setTargetRef(nextNode.getId());
            ((Task)nextNode).getIncomingFlows().remove(s0);
            ((Task)nextNode).getIncomingFlows().add(s2);
            SequenceFlow s3 = new SequenceFlow();
            s3.setId("sf_auto_" + UUID.randomUUID().toString());
            s3.setSourceFlowElement((FlowElement)exclusiveGateway);
            s3.setSourceRef(exclusiveGateway.getId());
            EndEvent endEvent = new EndEvent();
            endEvent.setId("end_auto_" + UUID.randomUUID().toString());
            s3.setTargetFlowElement((FlowElement)endEvent);
            s3.setTargetRef(endEvent.getId());
            s3.setConditionExpression("${approveResult=='REJECTED'}");
            exclusiveGateway.setOutgoingFlows(Arrays.asList(s2, s3));
            exclusiveGateway.setDefaultFlow(s2.getId());
            bpmnParse.getSequenceFlows().put(s1.getId(), s1);
            bpmnParse.getSequenceFlows().put(s2.getId(), s2);
            bpmnParse.getSequenceFlows().put(s3.getId(), s3);
        }
    }

    private void multiInstance(UserTask userTask) {
        MultiInstanceLoopCharacteristics loopCharacteristics = new MultiInstanceLoopCharacteristics();
        loopCharacteristics.setElementVariable("assignee");
        loopCharacteristics.setInputDataItem("approvalCandidates");
        loopCharacteristics.setSequential(false);
        String condition = "${nrOfRejected>0}";
        FormProperty property = ActivitiUtils.getFormPropertyById(userTask.getFormProperties(), "APPROVAL_STRATEGY");
        if (property != null && StringUtil.isNotEmpty(property.getName())) {
            String code = property.getName();
            ApproveStrategy record = new ApproveStrategy();
            record.setCode(code);
            record.setEnableFlag("Y");
            record = this.strategyMapper.selectOne(record);
            if (record != null) {
                condition = record.getCondition();
                FormProperty num = ActivitiUtils.getFormPropertyById(userTask.getFormProperties(), "WFL_NUM");
                String numValue = "1";
                if (num != null && StringUtils.isNotEmpty((String)num.getName())) {
                    numValue = num.getName();
                }
                condition = condition.replace("WFL_NUM", numValue);
            }
        }
        loopCharacteristics.setCompletionCondition(condition);
        userTask.setAssignee("${assignee}");
        userTask.setLoopCharacteristics(loopCharacteristics);
    }
}

