/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.account.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.account.dto.Role;
import com.hand.hap.account.dto.RoleExt;
import com.hand.hap.account.dto.User;
import com.hand.hap.account.exception.RoleException;
import com.hand.hap.account.mapper.RoleMapper;
import com.hand.hap.account.mapper.UserRoleMapper;
import com.hand.hap.account.service.IRole;
import com.hand.hap.account.service.IRoleService;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.cache.Cache;
import com.hand.hap.cache.CacheManager;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.function.service.IRoleFunctionService;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.mybatis.common.query.Comparison;
import com.hand.hap.mybatis.common.query.WhereField;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleServiceImpl
extends BaseServiceImpl<Role>
implements IRoleService {
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private IRoleFunctionService roleFunctionService;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IUserService iUserService;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<Role> selectRoles(IRequest request, Role role, int pageNum, int pageSize) {
        Criteria criteria = new Criteria(role);
        criteria.where("roleId", new WhereField("roleCode", Comparison.LIKE), new WhereField("roleName", Comparison.LIKE), new WhereField("roleDescription", Comparison.LIKE));
        return super.selectOptions(request, role, criteria, pageNum, pageSize);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<IRole> selectRoleNotUserRoles(IRequest request, RoleExt roleExt, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        List<IRole> list = this.roleMapper.selectRoleNotUserRoles(roleExt);
        return list;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<IRole> selectRolesByUser(IRequest requestContext, User user) {
        List<IRole> rootRoles = this.roleMapper.selectUserRoles(user.getUserId());
        return rootRoles;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<IRole> selectUserRolesByUserId(Long userId) {
        List<IRole> rootRoles = this.roleMapper.selectUserRolesByUserId(userId);
        return rootRoles;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public void checkUserRoleExists(Long userId, Long roleId) throws RoleException {
        if (this.roleMapper.selectUserRoleCount(userId, roleId) != 1) {
            throw new RoleException("error.account_role_invalid", "error.account_role_invalid", null);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public IRole selectRoleByCode(String roleCode) {
        IRole role = this.getRoleCache().getValue(roleCode);
        if (role == null) {
            Role record = new Role();
            record.setRoleCode(roleCode);
            role = this.roleMapper.selectOne(record);
            if (role != null) {
                this.getRoleCache().setValue(roleCode, role);
            }
        }
        return role;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<IRole> selectActiveRolesByUser(IRequest requestContext, User user) {
        if (null == user.getRoleCode()) {
            user = this.iUserService.selectByUserName(user.getUserName());
        }
        ArrayList<IRole> roles = new ArrayList<IRole>();
        for (String roleCode : user.getRoleCode()) {
            roles.add(this.selectRoleByCode(roleCode));
        }
        return roles.stream().filter(role -> role.isActive()).collect(Collectors.toList());
    }

    @Override
    protected boolean useSelectiveUpdate() {
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deleteByPrimaryKey(Role record) {
        int ret = super.deleteByPrimaryKey(record);
        this.userRoleMapper.deleteByRoleId(record.getRoleId());
        this.roleFunctionService.removeRoleFunctionByRoleId(record.getRoleId());
        this.getRoleCache().remove(record.getRoleCode());
        return ret;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Role updateByPrimaryKey(IRequest request, @StdWho Role record) {
        int count = this.roleMapper.updateByPrimaryKey(record);
        this.checkOvn(count, record);
        this.getRoleCache().remove(record.getRoleCode());
        this.getRoleCache().setValue(record.getRoleCode(), record);
        return record;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Role insertSelective(IRequest request, Role record) {
        int count = this.roleMapper.insertSelective(record);
        this.checkOvn(count, record);
        this.getRoleCache().setValue(record.getRoleCode(), record);
        return record;
    }

    private Cache<IRole> getRoleCache() {
        return this.cacheManager.getCache("role");
    }
}

