/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.task.service.impl;

import com.hand.hap.core.AppContextInitListener;
import com.hand.hap.task.info.TaskDataInfo;
import com.hand.hap.task.service.IExecuteListener;
import com.hand.hap.task.service.IExecuteService;
import com.hand.hap.task.service.ITaskDetailService;
import com.hand.hap.task.service.ITaskExecutionService;
import com.hand.hap.task.service.impl.ExecuteServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;

@Service
public class ExecuteServiceImpl
implements IExecuteService,
AppContextInitListener {
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ITaskDetailService taskDetailService;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private ITaskExecutionService taskExecutionService;
    private List<IExecuteListener> executeListeners = Collections.emptyList();

    public void taskExecute(TaskDataInfo taskDataInfo) {
        TaskThread taskThread = new TaskThread(this, taskDataInfo, null);
        taskThread.setName("TASKQUEUE-" + taskDataInfo.getExecutionId());
        try {
            this.taskExecutor.execute((Runnable)taskThread);
        }
        catch (RejectedExecutionException e) {
            this.taskExecutionService.updateStatus(taskDataInfo.getExecutionId(), "UNEXECUTED");
            this.taskExecutionService.batchUpdateStatus(taskDataInfo.getExecutionId(), "READY", "UNEXECUTED");
            throw e;
        }
    }

    public void contextInitialized(ApplicationContext applicationContext) {
        this.executeListeners = new ArrayList(applicationContext.getBeansOfType(IExecuteListener.class).values());
        this.executeListeners.sort(Comparator.comparingInt(IExecuteListener::getOrder));
    }

    static /* synthetic */ PlatformTransactionManager access$100(ExecuteServiceImpl x0) {
        return x0.transactionManager;
    }

    static /* synthetic */ List access$200(ExecuteServiceImpl x0) {
        return x0.executeListeners;
    }

    static /* synthetic */ ITaskExecutionService access$300(ExecuteServiceImpl x0) {
        return x0.taskExecutionService;
    }

    static /* synthetic */ ApplicationContext access$400(ExecuteServiceImpl x0) {
        return x0.applicationContext;
    }

    static /* synthetic */ ITaskDetailService access$500(ExecuteServiceImpl x0) {
        return x0.taskDetailService;
    }
}

