/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.hand.hap.cache.impl.HashStringRedisCacheGroup;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.SysPreferences;
import com.hand.hap.system.mapper.SysPreferencesMapper;
import com.hand.hap.system.service.ISysPreferencesService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysPreferencesServiceImpl
extends BaseServiceImpl<SysPreferences>
implements ISysPreferencesService {
    private Logger logger = LoggerFactory.getLogger(SysPreferencesServiceImpl.class);
    @Autowired
    private SysPreferencesMapper sysPreferencesMapper;
    @Autowired
    @Qualifier(value="preferenceCache")
    private HashStringRedisCacheGroup<SysPreferences> preferenceCache;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public List<SysPreferences> saveSysPreferences(IRequest requestContext, List<SysPreferences> preferences) {
        if (preferences.isEmpty() && this.logger.isDebugEnabled()) {
            this.logger.debug("sysPreferences is null");
        }
        for (SysPreferences sysPreferences : preferences) {
            int count;
            sysPreferences.setUserId(requestContext.getUserId());
            if (sysPreferences.getPreferencesId() == null) {
                count = this.sysPreferencesMapper.insertSelective((Object)sysPreferences);
                this.checkOvn(count, (Object)sysPreferences);
                this.preferenceCache.setValue(sysPreferences.getUserId() + "", sysPreferences.getPreferences(), (Object)sysPreferences);
                continue;
            }
            count = this.sysPreferencesMapper.updatePreferLine(sysPreferences);
            this.checkOvn(count, (Object)sysPreferences);
            this.preferenceCache.remove(sysPreferences.getUserId() + "", sysPreferences.getPreferences());
            this.preferenceCache.setValue(sysPreferences.getUserId() + "", sysPreferences.getPreferences(), (Object)sysPreferences);
        }
        return preferences;
    }

    public List<SysPreferences> querySysPreferences(IRequest requestContext, SysPreferences preferences) {
        List list = this.preferenceCache.getGroupAll(preferences.getUserId() + "");
        if (list != null && !list.isEmpty()) {
            return list;
        }
        List pres = this.sysPreferencesMapper.select((Object)preferences);
        pres.forEach(pre -> this.preferenceCache.setValue(pre.getUserId() + "", pre.getPreferences(), pre));
        return pres;
    }

    public List<SysPreferences> querySysPreferencesByDb(IRequest requestContext, SysPreferences preferences) {
        return this.sysPreferencesMapper.select((Object)preferences);
    }

    public SysPreferences selectUserPreference(String preference, Long userId) {
        SysPreferences pre = (SysPreferences)this.preferenceCache.getValue(userId + "", preference);
        if (pre != null) {
            return pre;
        }
        SysPreferences p = new SysPreferences();
        p.setPreferences(preference);
        p.setUserId(userId);
        p = this.sysPreferencesMapper.selectUserPreference(p);
        if (p != null) {
            this.preferenceCache.setValue(userId + "", preference, (Object)p);
        }
        return p;
    }
}

