/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.dto;

import com.hand.hap.core.annotation.Children;
import com.hand.hap.core.annotation.MultiLanguageField;
import com.hand.hap.mybatis.common.query.JoinCache;
import com.hand.hap.mybatis.common.query.JoinCode;
import com.hand.hap.mybatis.common.query.JoinLov;
import com.hand.hap.mybatis.entity.EntityField;
import com.hand.hap.mybatis.mapperhelper.FieldHelper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DTOClassInfo {
    private static final Comparator<EntityField> FIELD_COMPARATOR = Comparator.comparing(EntityField::getName);
    private static final Class<? extends Annotation>[] CONCERNED_ANNOTATION = new Class[]{Id.class, Children.class, MultiLanguageField.class, JoinCache.class, JoinCode.class, JoinLov.class};
    private static final Map<Class<?>, EntityField[]>[] CLASS_ANNO_MAPPING = new HashMap[CONCERNED_ANNOTATION.length];
    private static final Map<Class<?>, Map<String, EntityField>> CLASS_FIELDS_MAPPING = new HashMap();
    private static final Map<String, String> CAMEL_UL_MAP;
    private static final Map<String, String> UL_CAMEL_MAP;

    private DTOClassInfo() {
    }

    public static EntityField[] getIdFields(Class<?> clazz) {
        return DTOClassInfo.getFields0(clazz, (int)0);
    }

    public static EntityField[] getChildrenFields(Class<?> clazz) {
        return DTOClassInfo.getFields0(clazz, (int)1);
    }

    public static EntityField[] getMultiLanguageFields(Class<?> clazz) {
        return DTOClassInfo.getFields0(clazz, (int)2);
    }

    private static EntityField[] getFields0(Class<?> clazz, int idx) {
        EntityField[] fields = (EntityField[])CLASS_ANNO_MAPPING[idx].get(clazz);
        if (fields == null) {
            DTOClassInfo.analysis(clazz);
            fields = (EntityField[])CLASS_ANNO_MAPPING[idx].get(clazz);
        }
        return fields;
    }

    public static EntityField[] getFieldsOfAnnotation(Class<?> clazz, Class<? extends Annotation> annoType) {
        int idx = Arrays.asList(CONCERNED_ANNOTATION).indexOf(annoType);
        if (idx != -1) {
            return DTOClassInfo.getFields0(clazz, (int)idx);
        }
        return new EntityField[0];
    }

    private static void analysis(Class<?> clazz) {
        List fields = FieldHelper.getAll(clazz);
        fields.sort(FIELD_COMPARATOR);
        List[] lists = new List[CONCERNED_ANNOTATION.length];
        for (int i = 0; i < CONCERNED_ANNOTATION.length; ++i) {
            lists[i] = new ArrayList();
        }
        HashMap<String, EntityField> fieldMap = new HashMap<String, EntityField>();
        for (EntityField f : fields) {
            for (int i = 0; i < CONCERNED_ANNOTATION.length; ++i) {
                if (f.getAnnotation(CONCERNED_ANNOTATION[i]) == null) continue;
                lists[i].add(f);
            }
            fieldMap.put(f.getName(), f);
        }
        CLASS_FIELDS_MAPPING.put(clazz, fieldMap);
        for (int i = 0; i < CLASS_ANNO_MAPPING.length; ++i) {
            EntityField[] fs = lists[i].toArray(new EntityField[lists[i].size()]);
            CLASS_ANNO_MAPPING[i].put(clazz, fs);
        }
    }

    public static EntityField getEntityField(Class<?> clazz, String field) {
        Map map = (Map)CLASS_FIELDS_MAPPING.get(clazz);
        if (map == null) {
            DTOClassInfo.analysis(clazz);
            map = (Map)CLASS_FIELDS_MAPPING.get(clazz);
        }
        return (EntityField)map.get(field);
    }

    public static Map<String, EntityField> getEntityFields(Class<?> clazz) {
        Map map = (Map)CLASS_FIELDS_MAPPING.get(clazz);
        if (map == null) {
            DTOClassInfo.analysis(clazz);
        }
        return map;
    }

    public static String camelToUnderLine(String camel) {
        String ret = (String)CAMEL_UL_MAP.get(camel);
        if (ret == null) {
            ArrayList<String> tmp = new ArrayList<String>();
            int lastIdx = 0;
            for (int i = 0; i < camel.length(); ++i) {
                if (!Character.isUpperCase(camel.charAt(i))) continue;
                tmp.add(camel.substring(lastIdx, i).toLowerCase());
                lastIdx = i;
            }
            tmp.add(camel.substring(lastIdx));
            ret = StringUtils.join(tmp, (String)"_");
            CAMEL_UL_MAP.put(camel, ret);
        }
        return ret;
    }

    public static String underLineToCamel(String str) {
        String camel = (String)UL_CAMEL_MAP.get(str);
        if (camel == null) {
            Object[] array = str.toLowerCase().split("_");
            for (int i = 1; i < array.length; ++i) {
                array[i] = StringUtils.capitalize((String)array[i]);
            }
            camel = StringUtils.join((Object[])array);
            UL_CAMEL_MAP.put(str, camel);
        }
        return camel;
    }

    public static String getColumnName(EntityField field) {
        Column col = (Column)field.getAnnotation(Column.class);
        if (col == null || StringUtils.isEmpty((String)col.name())) {
            return DTOClassInfo.camelToUnderLine((String)field.getName());
        }
        return col.name();
    }

    public static String getTableName(Class<?> clazz) {
        String tableName = null;
        Table anonotation = DTOClassInfo.getTableAnnotation(clazz);
        if (anonotation != null) {
            tableName = anonotation.name();
        }
        return tableName;
    }

    static Table getTableAnnotation(Class<?> clazz) {
        Table annotation = null;
        annotation = clazz.getAnnotation(Table.class);
        if (annotation == null && clazz.getSuperclass() != null) {
            annotation = DTOClassInfo.getTableAnnotation(clazz.getSuperclass());
        }
        return annotation;
    }

    static {
        for (int i = 0; i < CLASS_ANNO_MAPPING.length; ++i) {
            DTOClassInfo.CLASS_ANNO_MAPPING[i] = new HashMap();
        }
        CAMEL_UL_MAP = new HashMap();
        UL_CAMEL_MAP = new HashMap();
    }
}

