/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.permission.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.security.permission.dto.DataPermissionRuleAssign;
import com.hand.hap.security.permission.dto.DataPermissionRuleDetail;
import com.hand.hap.security.permission.mapper.DataPermissionRuleAssignMapper;
import com.hand.hap.security.permission.service.IDataPermissionRuleDetailService;
import com.hand.hap.system.service.ILovService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataPermissionRuleDetailServiceImpl
extends BaseServiceImpl<DataPermissionRuleDetail>
implements IDataPermissionRuleDetailService {
    @Autowired
    private ILovService lovService;
    @Autowired
    DataPermissionRuleAssignMapper dataPermissionRuleAssignMapper;
    @Autowired
    IMessagePublisher iMessagePublisher;

    public List<DataPermissionRuleDetail> selectRuleManageDetail(DataPermissionRuleDetail dto, int page, int pageSize, IRequest request) throws IllegalAccessException {
        List lists = this.selectOptions(request, (Object)dto, null, Integer.valueOf(page), Integer.valueOf(pageSize));
        return lists;
    }

    @Transactional(rollbackFor={Exception.class})
    public void removeDataMaskRuleDetailWithAssign(List<DataPermissionRuleDetail> dataMaskRuleManageDetails) {
        this.batchDelete(dataMaskRuleManageDetails);
        dataMaskRuleManageDetails.forEach(v -> {
            DataPermissionRuleAssign assign = new DataPermissionRuleAssign();
            assign.setDetailId(v.getDetailId());
            this.dataPermissionRuleAssignMapper.delete((Object)assign);
        });
    }

    public List<DataPermissionRuleDetail> updateDataMaskRuleDetail(IRequest iRequest, List<DataPermissionRuleDetail> dto) {
        List dataMaskRuleManageDetails = ((IDataPermissionRuleDetailService)this.self()).batchUpdate(iRequest, dto);
        this.updateCache(dto.get(0).getRuleId());
        return dataMaskRuleManageDetails;
    }

    public void removeDataMaskRuleDetail(List<DataPermissionRuleDetail> dataMaskRuleManageDetails) {
        ((IDataPermissionRuleDetailService)this.self()).removeDataMaskRuleDetailWithAssign(dataMaskRuleManageDetails);
        this.updateCache(dataMaskRuleManageDetails.get(0).getRuleId());
    }

    private void updateCache(Long ruleId) {
        this.iMessagePublisher.publish("dataPermission.ruleRefresh", (Object)ruleId);
    }
}

