/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.oauth.service.impl;

import com.hand.hap.cache.Cache;
import com.hand.hap.cache.CacheManager;
import com.hand.hap.core.IRequest;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.security.oauth.dto.Oauth2ClientDetails;
import com.hand.hap.security.oauth.mapper.Oauth2ClientDetailsMapper;
import com.hand.hap.security.oauth.service.IOauth2ClientDetailsService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class Oauth2ClientDetailsServiceImpl
extends BaseServiceImpl<Oauth2ClientDetails>
implements IOauth2ClientDetailsService {
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private Oauth2ClientDetailsMapper detailsMapper;

    public Oauth2ClientDetails insertSelective(IRequest request, Oauth2ClientDetails record) {
        this.detailsMapper.insertSelective((Object)record);
        this.getClientCache().setValue(record.getClientId(), (Object)record);
        return record;
    }

    public Oauth2ClientDetails updateClient(IRequest request, Oauth2ClientDetails clientDetails) {
        Criteria criteria = new Criteria((Object)clientDetails);
        criteria.update(new String[]{"accessTokenValidity", "clientSecret", "additionalInformation", "authorities", "autoApprove", "redirectUri", "refreshTokenValidity", "scope", "authorizedGrantTypes", "resourceIds"});
        int count = this.detailsMapper.updateByPrimaryKeyOptions((Object)clientDetails, criteria);
        this.checkOvn(count, (Object)clientDetails);
        this.getClientCache().remove(clientDetails.getClientId());
        this.getClientCache().setValue(clientDetails.getClientId(), (Object)clientDetails);
        return clientDetails;
    }

    public List<Oauth2ClientDetails> batchUpdate(IRequest requestContext, List<Oauth2ClientDetails> clientDetailses) {
        for (Oauth2ClientDetails details : clientDetailses) {
            if (details.getId() == null) {
                details.setClientSecret(UUID.randomUUID().toString());
                ((IOauth2ClientDetailsService)this.self()).insertSelective(requestContext, (Object)details);
                continue;
            }
            ((IOauth2ClientDetailsService)this.self()).updateClient(requestContext, details);
        }
        return clientDetailses;
    }

    public int deleteByPrimaryKey(Oauth2ClientDetails details) {
        if (StringUtils.isEmpty((String)details.getClientId())) {
            details = (Oauth2ClientDetails)this.detailsMapper.selectByPrimaryKey((Object)details);
        }
        int result = this.detailsMapper.deleteByPrimaryKey((Object)details);
        this.getClientCache().remove(details.getClientId());
        return result;
    }

    public Oauth2ClientDetails selectByClientId(String clientID) {
        Oauth2ClientDetails details = (Oauth2ClientDetails)this.getClientCache().getValue(clientID);
        if (details == null && (details = this.detailsMapper.selectByClientId(clientID)) != null) {
            this.getClientCache().setValue(clientID, (Object)details);
        }
        return details;
    }

    public String updatePassword(Long id) {
        String uuid = UUID.randomUUID().toString();
        this.detailsMapper.updatePassword(id, uuid);
        return uuid;
    }

    Cache<Oauth2ClientDetails> getClientCache() {
        return this.cacheManager.getCache("oauth_client");
    }

    public Oauth2ClientDetails selectById(Long id) {
        return (Oauth2ClientDetails)this.detailsMapper.selectByPrimaryKey((Object)id);
    }
}

