/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import com.hand.hap.core.components.SysConfigManager;
import com.hand.hap.message.profile.SystemConfigListener;
import com.hand.hap.mybatis.util.StringUtil;
import com.hand.hap.security.IAuthenticationSuccessListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;

public class CustomAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler
implements SystemConfigListener {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    SysConfigManager sysConfigManager;
    private RequestCache requestCache = new HttpSessionRequestCache();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, IAuthenticationSuccessListener> listeners;
    public static final String DEFAULT_TARGET_URL = "DEFAULT_TARGET_URL";
    private final String loginOauthUrl = "/login?oauth";
    private final String loginUrl = "/login";
    private final String logoutUrl = "/logout";
    private final String indexUrl = "/index";
    private final String refererStr = "Referer";
    private final String loginCasUrl = "/login/cas";
    private final String functionCodeStr = "functionCode";
    private final String ROLE_URL = "/role";

    public CustomAuthenticationSuccessHandler() {
        this.setDefaultTargetUrl("/");
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String referer;
        if (this.listeners == null) {
            this.listeners = this.applicationContext.getBeansOfType(IAuthenticationSuccessListener.class);
        }
        if ((referer = request.getHeader("Referer")) != null && referer.endsWith("/login?oauth")) {
            super.onAuthenticationSuccess(request, response, authentication);
            return;
        }
        this.clearAuthenticationAttributes(request);
        ArrayList list = new ArrayList();
        list.addAll(this.listeners.values());
        Collections.sort(list);
        IAuthenticationSuccessListener successListener = null;
        String requestURI = request.getRequestURI();
        boolean isCas = requestURI.endsWith("/login/cas");
        try {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IAuthenticationSuccessListener listener;
                successListener = listener = (IAuthenticationSuccessListener)iterator.next();
                successListener.onAuthenticationSuccess(request, response, authentication);
            }
            HttpSession session = request.getSession(false);
            session.setAttribute("login_change_index", (Object)"CHANGE");
        }
        catch (Exception e) {
            this.logger.error("authentication success, but error occurred in " + successListener, (Throwable)e);
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
            request.setAttribute("error", (Object)true);
            request.setAttribute("exception", (Object)e);
            if (isCas) {
                request.getRequestDispatcher("/casLoginFailure").forward((ServletRequest)request, (ServletResponse)response);
            } else {
                request.getRequestDispatcher("/login").forward((ServletRequest)request, (ServletResponse)response);
            }
            return;
        }
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        if (savedRequest != null) {
            Long roleId;
            HttpSession session;
            String targetUrl = savedRequest.getRedirectUrl();
            if (targetUrl.endsWith("/login")) {
                targetUrl = targetUrl.substring(0, targetUrl.lastIndexOf("/login"));
                targetUrl = targetUrl + "/";
            } else if (targetUrl.endsWith("/logout")) {
                targetUrl = targetUrl.substring(0, targetUrl.lastIndexOf("/logout"));
                targetUrl = targetUrl + "/";
            }
            String defaultTarget = this.getDefaultTargetUrl();
            if (!(targetUrl.contains("functionCode") || "/index".equalsIgnoreCase(defaultTarget) || "/".equalsIgnoreCase(defaultTarget))) {
                targetUrl = this.getDefaultTargetUrl() + "?targetUrl=" + targetUrl;
            }
            if ((session = request.getSession(false)) != null && !this.sysConfigManager.getRoleMergeFlag() && (roleId = (Long)session.getAttribute("roleId")) == null) {
                session.setAttribute("targetUrl", (Object)targetUrl);
                this.getRedirectStrategy().sendRedirect(request, response, "/role");
                return;
            }
            this.getRedirectStrategy().sendRedirect(request, response, targetUrl);
            return;
        }
        this.handle(request, response, authentication);
    }

    public List<String> getAcceptedProfiles() {
        return Collections.singletonList(DEFAULT_TARGET_URL);
    }

    public void updateProfile(String profileName, String profileValue) {
        if (StringUtil.isNotEmpty((String)profileValue)) {
            this.setDefaultTargetUrl(profileValue);
        }
    }

    private void selectRole(HttpServletRequest request, HttpServletResponse response, String targetUrl) {
    }
}

