/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.codahale.metrics.servlet.InstrumentedFilter;
import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.MetricsServlet;
import com.ryantenney.metrics.spring.config.annotation.MetricsConfigurerAdapter;
import java.lang.management.ManagementFactory;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;

public class MetricsConfigurationBean
extends MetricsConfigurerAdapter {
    private static final String PROP_METRIC_REG_JVM_MEMORY = "jvm.memory";
    private static final String PROP_METRIC_REG_JVM_GARBAGE = "jvm.garbage";
    private static final String PROP_METRIC_REG_JVM_THREADS = "jvm.threads";
    private static final String PROP_METRIC_REG_JVM_FILES = "jvm.files";
    private static final String PROP_METRIC_REG_JVM_BUFFERS = "jvm.buffers";
    private final Logger log = LoggerFactory.getLogger(MetricsConfigurationBean.class);
    private MetricRegistry metricRegistry = new MetricRegistry();
    private HealthCheckRegistry healthCheckRegistry = new HealthCheckRegistry();
    @Autowired
    private ServletContext context;

    @Bean
    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    @Bean
    public HealthCheckRegistry getHealthCheckRegistry() {
        return this.healthCheckRegistry;
    }

    @PostConstruct
    public void init() {
        this.log.debug("Registering JVM gauges");
        this.metricRegistry.register(PROP_METRIC_REG_JVM_MEMORY, (Metric)new MemoryUsageGaugeSet());
        this.metricRegistry.register(PROP_METRIC_REG_JVM_GARBAGE, (Metric)new GarbageCollectorMetricSet());
        this.metricRegistry.register(PROP_METRIC_REG_JVM_THREADS, (Metric)new ThreadStatesGaugeSet());
        this.metricRegistry.register(PROP_METRIC_REG_JVM_FILES, (Metric)new FileDescriptorRatioGauge());
        this.metricRegistry.register(PROP_METRIC_REG_JVM_BUFFERS, (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.context.setAttribute(MetricsServlet.METRICS_REGISTRY, (Object)this.metricRegistry);
        this.context.setAttribute(InstrumentedFilter.REGISTRY_ATTRIBUTE, (Object)this.metricRegistry);
        this.context.setAttribute(HealthCheckServlet.HEALTH_CHECK_REGISTRY, (Object)this.healthCheckRegistry);
    }
}

