/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message.websocket;

import com.hand.hap.message.websocket.WebSocketSessionManager;
import com.hand.hap.system.service.IBadgeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class DefaultWebSocketHandler
implements WebSocketHandler {
    private final Logger logger = LoggerFactory.getLogger(DefaultWebSocketHandler.class);
    @Autowired
    private WebSocketSessionManager webSocketSessionManager;
    @Autowired
    private IBadgeService badgeService;

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        this.webSocketSessionManager.addSession(session);
        this.badgeService.initBadgeMessage(session);
    }

    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        String userName = session.getPrincipal().getName();
        if (session.isOpen()) {
            session.close();
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        this.webSocketSessionManager.removeSession(session);
    }

    public boolean supportsPartialMessages() {
        return false;
    }
}

