/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.message.components.ChannelAndQueuePrefix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class MessagePublisherImpl
implements IMessagePublisher {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private Logger logger = LoggerFactory.getLogger(MessagePublisherImpl.class);

    public void publish(String channel, Object message) {
        block4: {
            channel = ChannelAndQueuePrefix.addPrefix((String)channel);
            if (message instanceof String || message instanceof Number) {
                this.redisTemplate.convertAndSend(channel, (Object)message.toString());
            } else {
                try {
                    this.redisTemplate.convertAndSend(channel, (Object)this.objectMapper.writeValueAsString(message));
                }
                catch (JsonProcessingException e) {
                    if (!this.logger.isErrorEnabled()) break block4;
                    this.logger.error("publish message failed.", (Throwable)e);
                }
            }
        }
    }

    public void rPush(String list, Object message) {
        this.message(list, message);
    }

    public void message(String name, Object message) {
        block4: {
            if (message instanceof String || message instanceof Number) {
                this.redisTemplate.opsForList().rightPush((Object)name, (Object)message.toString());
            } else {
                try {
                    this.redisTemplate.opsForList().rightPush((Object)name, (Object)this.objectMapper.writeValueAsString(message));
                }
                catch (JsonProcessingException e) {
                    if (!this.logger.isErrorEnabled()) break block4;
                    this.logger.error("push data failed.", (Throwable)e);
                }
            }
        }
    }
}

