/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message.components;

import com.hand.hap.cache.impl.RoleResourceCache;
import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.message.TopicMonitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@TopicMonitor(channel={"cache.role.resource"})
public class DefaultRoleResourceListener
implements IMessageConsumer<Long> {
    public static final String CACHE_ROLE_RESOURCE = "cache.role.resource";
    @Autowired
    private RoleResourceCache roleResourceCache;
    private Map<Long, List<Long>> roleResourceMap = new HashMap();

    public void onMessage(Long roleId, String pattern) {
        if (null == roleId) {
            this.roleResourceCache.reload();
            this.roleResourceMap.clear();
        } else {
            this.roleResourceCache.loadRoleResource(roleId);
            this.roleResourceMap.remove(roleId);
            Object[] resourceIs = this.roleResourceCache.getValue(roleId + "");
            if (ArrayUtils.isNotEmpty((Object[])resourceIs)) {
                this.roleResourceMap.put(roleId, Arrays.asList(resourceIs));
            }
        }
    }

    public List<Long> getRoleResource(Long roleId) {
        Object[] ids;
        List<Object> resourceIds = (List<Object>)this.roleResourceMap.get(roleId);
        if (CollectionUtils.isEmpty((Collection)resourceIds) && ArrayUtils.isNotEmpty((Object[])(ids = this.roleResourceCache.getValue(roleId + "")))) {
            resourceIds = Arrays.asList(ids);
            this.roleResourceMap.put(roleId, resourceIds);
        }
        return resourceIds;
    }
}

