/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.fnd.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.fnd.dto.Company;
import com.hand.hap.fnd.service.ICompanyService;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.mybatis.common.query.Comparison;
import com.hand.hap.mybatis.common.query.WhereField;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fnd/company", "/api/fnd/company"})
public class CompanyController
extends BaseController {
    @Autowired
    ICompanyService companyService;

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData select(Company company, HttpServletRequest request, HttpServletResponse response, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest requestCtx = this.createRequestContext(request);
        Criteria criteria = new Criteria((Object)company);
        criteria.where(new Object[]{new WhereField("companyCode", Comparison.LIKE), "companyId", "companyType", "parentCompanyId", "companyFullName", "companyShortName"});
        return new ResponseData(this.companyService.selectOptions(requestCtx, (Object)company, criteria, Integer.valueOf(page), Integer.valueOf(pagesize)));
    }

    @PostMapping(value={"/submit", "/update"})
    public ResponseData update(@RequestBody List<Company> companies, BindingResult result, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        this.getValidator().validate(companies, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        return new ResponseData(this.companyService.batchUpdate(requestCtx, companies));
    }

    @PostMapping(value={"/remove"})
    public ResponseData delete(@RequestBody List<Company> companies, HttpServletRequest request) {
        this.companyService.batchDelete(companies);
        return new ResponseData();
    }
}

