/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.flexfield.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.flexfield.dto.FlexRule;
import com.hand.hap.flexfield.dto.WarpFlexRuleField;
import com.hand.hap.flexfield.service.IFlexRuleService;
import com.hand.hap.flexfield.service.impl.FlexRuleServiceImpl;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.RequestContextUtils;

@RestController
@RequestMapping(value={"/fnd/flex/rule", "/api/fnd/flex/rule"})
public class FlexRuleController
extends BaseController {
    @Autowired
    private IFlexRuleService service;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData query(FlexRule dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.select(requestContext, (Object)dto, page, pageSize));
    }

    @RequestMapping(value={"/matching"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData matchingRule(String ruleSetCode, @RequestBody JSONObject viewModel, HttpServletRequest request) {
        IRequest requestContext;
        Set entrySet = viewModel.entrySet();
        ResponseData responseData = this.service.matchingRule(ruleSetCode, entrySet, requestContext = this.createRequestContext(request));
        if (null == responseData.getRows()) {
            return responseData;
        }
        List warpFlexRuleFields = responseData.getRows();
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        warpFlexRuleFields.forEach(v -> FlexRuleServiceImpl.setPrompt((WarpFlexRuleField)v, (Locale)locale, (MessageSource)this.messageSource));
        return responseData;
    }

    @PostMapping(value={"/submit"})
    public ResponseData update(@RequestBody List<FlexRule> dto, HttpServletRequest request, BindingResult result) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @PostMapping(value={"/remove"})
    public ResponseData delete(HttpServletRequest request, @RequestBody List<FlexRule> dto) {
        this.service.deleteRule(dto);
        return new ResponseData();
    }
}

