/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.excel.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hand.hap.excel.ExcelException;
import com.hand.hap.excel.service.IHapExcelExportService;
import com.hand.hap.excel.service.impl.HapExcelExportImpl;
import com.hand.hap.excel.util.TableUtils;
import com.hand.hap.generator.service.impl.FileUtil;
import com.hand.hap.mybatis.entity.EntityColumn;
import com.hand.hap.mybatis.entity.EntityTable;
import com.hand.hap.system.dto.ResponseData;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.support.RequestContextUtils;

@Component
public class HapExcelExportService
implements IHapExcelExportService {
    @Autowired
    DataSource dataSource;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    ThreadLocal<Long> index = ThreadLocal.withInitial(() -> new Long(1L));
    @Autowired
    MessageSource messageSource;

    public void exportAndDownloadExcel(Object responseData, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, List<String> columns) throws ExcelException, IOException {
        ResponseData rs = (ResponseData)responseData;
        if (rs.getRows().size() == 0) {
            return;
        }
        SXSSFWorkbook wb = new SXSSFWorkbook();
        try (HapExcelExportImpl hapExcelExport = null;){
            hapExcelExport = new HapExcelExportImpl(wb, this.dataSource, columns);
            Object r = rs.getRows().get(0);
            HapExcelExportImpl.setExcelHeader((HttpServletResponse)httpServletResponse, (HttpServletRequest)httpServletRequest, (String)"exportFile");
            hapExcelExport.createExcelTemplate(TableUtils.getTable(r.getClass()).getName());
            hapExcelExport.fillSheet(rs.getRows(), r.getClass());
            hapExcelExport.write((OutputStream)httpServletResponse.getOutputStream());
        }
    }

    public ArrayNode getAllExportColumn(String tableName, HttpServletRequest request) {
        Class parentDto = TableUtils.getTableClass((String)tableName);
        ObjectMapper columnTree = new ObjectMapper();
        ArrayNode jsonNodes = columnTree.createArrayNode();
        this.parseClass(parentDto, columnTree, request, jsonNodes, (Long)this.index.get());
        parentDto.getSimpleName();
        this.index.set(new Long(1L));
        return jsonNodes;
    }

    private void parseClass(Class dto, ObjectMapper columnTree, HttpServletRequest request, ArrayNode rootNode, Long parentId) {
        Long id = (Long)this.index.get();
        EntityTable entityTable = TableUtils.getTable((Class)dto);
        String dtoName = dto.getSimpleName();
        Set columns = entityTable.getAllColumns();
        ObjectNode objectNode = columnTree.createObjectNode();
        objectNode.put("text", dtoName);
        objectNode.put("value", dtoName);
        objectNode.put("ischecked", false);
        objectNode.put("hasChildren", false);
        objectNode.put("id", id);
        objectNode.put("parentId", id - 1L == 0L ? null : parentId);
        rootNode.add((JsonNode)objectNode);
        int j = 1;
        for (EntityColumn column : columns) {
            String columnName = FileUtil.columnToCamel((String)column.getColumn());
            String description = this.messageSource.getMessage((dtoName + "." + columnName).toLowerCase(), null, RequestContextUtils.getLocale((HttpServletRequest)request));
            if (description.equals((dtoName + "." + columnName).toLowerCase())) continue;
            ObjectNode node = columnTree.createObjectNode();
            node.put("text", description);
            node.put("value", dtoName + "." + columnName);
            node.put("ischecked", false);
            node.put("id", id + (long)j);
            node.put("parentId", id);
            rootNode.add((JsonNode)node);
            ++j;
        }
        this.index.set(id + (long)j);
        for (Class clz : TableUtils.getChildren((Class)dto)) {
            this.parseClass(clz, columnTree, request, rootNode, id);
        }
    }
}

