/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view.ui;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.hand.hap.core.web.view.ReferenceType;
import com.hand.hap.core.web.view.XMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TransportMethod {
    private Boolean cache;
    private String contentType;
    private Object data;
    private String dataType;
    private String type;
    private Object url;
    private static final String PROPERTITY_CACHE = "cache";
    private static final String PROPERTITY_CONTENT_TYPE = "contentType";
    private static final String PROPERTITY_DATA = "data";
    private static final String PROPERTITY_DATA_TYPE = "dataType";
    private static final String PROPERTITY_TYPE = "type";
    private static final String PROPERTITY_URL = "url";

    public static TransportMethod parse(XMap view) {
        TransportMethod transportMethod = new TransportMethod();
        if (view != null) {
            transportMethod.setCache(view.getBoolean((Object)PROPERTITY_CACHE));
            transportMethod.setContentType(view.getString((Object)PROPERTITY_CONTENT_TYPE));
            if (view.getString((Object)PROPERTITY_DATA) != null) {
                transportMethod.setData(new ReferenceType(view.getString((Object)PROPERTITY_DATA)));
            }
            transportMethod.setDataType(view.getString((Object)PROPERTITY_DATA_TYPE));
            transportMethod.setType(view.getString((Object)PROPERTITY_TYPE));
            transportMethod.setUrl(view.getPropertity(PROPERTITY_URL));
            return transportMethod;
        }
        return null;
    }

    public XMap toXMap(String name) {
        XMap map = new XMap("h", "http://www.hand-china.com/hap", name);
        map.put((Object)PROPERTITY_CACHE, (Object)this.getCache());
        map.put((Object)PROPERTITY_CONTENT_TYPE, (Object)this.getContentType());
        map.put((Object)PROPERTITY_DATA, this.getData());
        map.put((Object)PROPERTITY_DATA_TYPE, (Object)this.getDataType());
        map.put((Object)PROPERTITY_TYPE, (Object)this.getType());
        map.put((Object)PROPERTITY_URL, this.getUrl());
        return map;
    }

    public Boolean getCache() {
        return this.cache;
    }

    public void setCache(Boolean cache) {
        this.cache = cache;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(ReferenceType data) {
        this.data = data;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getUrl() {
        return this.url;
    }

    public void setUrl(Object url) {
        this.url = url;
    }
}

