/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.util;

import com.hand.hap.attachment.ContentTypeFilter;
import com.hand.hap.attachment.Controller;
import com.hand.hap.attachment.FileInfo;
import com.hand.hap.attachment.Uploader;
import com.hand.hap.attachment.dto.AttachCategory;
import com.hand.hap.attachment.dto.Attachment;
import com.hand.hap.attachment.dto.SysFile;
import com.hand.hap.attachment.exception.StoragePathNotExsitException;
import java.io.File;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class UploadUtil {
    public static final String BASE_PATH = "${basePath}";

    protected UploadUtil() {
    }

    public static void initUploaderParams(Uploader uploader, AttachCategory category) throws StoragePathNotExsitException {
        uploader.setCategory(category);
        if (category.getAllowedFileSize() != null) {
            uploader.setSingleFileSize(category.getAllowedFileSize().longValue());
        }
        String path = category.getCategoryPath();
        uploader.setController((Controller)new /* Unavailable Anonymous Inner Class!! */);
        if (StringUtils.isNotBlank((CharSequence)category.getAllowedFileType())) {
            String[] allowedExts = category.getAllowedFileType().toLowerCase().split(";");
            uploader.setFilter((ContentTypeFilter)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public static SysFile genSysFile(FileInfo f, Long createdBy, Long lastUpdateBy) {
        SysFile sysFile = new SysFile();
        sysFile.setFileName(f.getOriginalName());
        sysFile.setFileSize(Long.valueOf(f.getFile().length()));
        sysFile.setUploadDate(new Date());
        sysFile.setCreatedBy(createdBy);
        sysFile.setLastUpdatedBy(lastUpdateBy);
        sysFile.setFilePath(f.getUrl());
        sysFile.setFileType(f.getContentType());
        return sysFile;
    }

    public static Attachment genAttachment(AttachCategory category, String sourceKey, Long creatBy, Long updateBy) {
        Attachment attach = new Attachment();
        attach.setCategoryId(category.getCategoryId());
        attach.setName(category.getSourceType());
        attach.setSourceType(category.getSourceType());
        attach.setStartActiveDate(new Date());
        attach.setEndActiveDate(new Date());
        attach.setSourceKey(sourceKey);
        attach.setCreatedBy(creatBy);
        attach.setLastUpdatedBy(updateBy);
        attach.setStatus("1");
        return attach;
    }

    public static void deleteFile(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return;
        }
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }
}

