/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.system.dto.Lov;
import com.hand.hap.system.dto.LovItem;
import com.hand.hap.system.mapper.LovItemMapper;
import com.hand.hap.system.mapper.LovMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LovCache
extends HashStringRedisCache<Lov> {
    private Logger logger = LoggerFactory.getLogger(LovCache.class);
    private String lovSql = LovMapper.class.getName() + ".selectAll";
    private String lovItemSql = LovItemMapper.class.getName() + ".selectAll";

    public LovCache() {
        this.setLoadOnStartUp(true);
        this.setType(Lov.class);
    }

    public Lov getValue(String key) {
        return (Lov)super.getValue(key);
    }

    public void setValue(String key, Lov lov) {
        super.setValue(key, (Object)lov);
    }

    public void reload(Long lovId) {
        try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
            Lov lov = (Lov)sqlSession.selectOne(LovMapper.class.getName() + ".selectByPrimaryKey", (Object)lovId);
            List lovItems = sqlSession.selectList(LovItemMapper.class.getName() + ".selectByLovId", (Object)lovId);
            lov.setLovItems(lovItems);
            this.setValue(lov.getCode(), lov);
        }
    }

    protected void initLoad() {
        block14: {
            HashMap<Long, Lov> tempMap = new HashMap<Long, Lov>(16);
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.lovSql, resultContext -> {
                    Lov lov = (Lov)resultContext.getResultObject();
                    tempMap.put(lov.getLovId(), lov);
                });
                sqlSession.select(this.lovItemSql, resultContext -> {
                    LovItem item = (LovItem)resultContext.getResultObject();
                    Lov lov = (Lov)tempMap.get(item.getLovId());
                    if (lov != null) {
                        ArrayList<LovItem> lovItems = lov.getLovItems();
                        if (lovItems == null) {
                            lovItems = new ArrayList<LovItem>();
                            lov.setLovItems(lovItems);
                        }
                        lovItems.add(item);
                    }
                });
                tempMap.forEach((k, v) -> this.setValue(v.getCode(), v));
                tempMap.clear();
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("init lov cache error:", e);
            }
        }
    }
}

