/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.attachment.service.impl;

import com.hand.hap.attachment.dto.AttachCategory;
import com.hand.hap.attachment.service.IAttachCategoryService;
import com.hand.hap.attachment.service.IAttachmentProvider;
import com.hand.hap.attachment.service.ISysFileService;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.core.util.FormatUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class AttachmentProvider
implements IAttachmentProvider {
    @Autowired
    private ISysFileService sysFileService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private IAttachCategoryService attachCategoryService;
    private Configuration configuration;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public String getAttachListHtml(String sourceType, String sourceKey, Locale locale, String contextPath) throws Exception {
        return this.getAttachHtml(sourceType, sourceKey, locale, contextPath, true, true);
    }

    public String getAttachHtml(String sourceType, String sourceKey, Locale locale, String contextPath, boolean enableRemove, boolean enableUpload) throws IOException, TemplateException {
        List files = this.sysFileService.queryFilesByTypeAndKey(RequestHelper.newEmptyRequest(), sourceType, sourceKey);
        AttachCategory category = this.attachCategoryService.selectAttachByCode(RequestHelper.newEmptyRequest(), sourceType);
        String html = "";
        if (category != null) {
            Template template = this.getConfiguration().getTemplate("Upload.ftl");
            files.forEach(f -> f.setFileSizeDesc(FormatUtil.formatFileSize((Long)f.getFileSize())));
            try (StringWriter out = new StringWriter();){
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("file", files);
                param.put("fid", AttachmentProvider.uuid());
                param.put("enableRemove", enableRemove);
                param.put("enableUpload", enableUpload);
                param.put("sourceType", sourceType);
                param.put("sourceKey", sourceKey);
                param.put("type", category.getAllowedFileType());
                param.put("size", category.getAllowedFileSize());
                param.put("unique", category.getIsUnique());
                param.put("filename", this.messageSource.getMessage("sysfile.filename", null, locale));
                param.put("filetype", this.messageSource.getMessage("sysfile.filetype", null, locale));
                param.put("filesize", this.messageSource.getMessage("sysfile.filesize", null, locale));
                param.put("upload", this.messageSource.getMessage("sysfile.uploaddate", null, locale));
                param.put("delete", this.messageSource.getMessage("hap.delete", null, locale));
                param.put("contextPath", contextPath);
                template.process(param, (Writer)out);
                out.flush();
                html = out.toString();
            }
        } else {
            return this.messageSource.getMessage("msg.warning.upload.folder.notfound", (Object[])new String[]{sourceType}, locale);
        }
        return html;
    }
}

