/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.api.application.service.impl;

import com.hand.hap.api.application.dto.ApiAccessLimit;
import com.hand.hap.api.application.dto.ApiApplication;
import com.hand.hap.api.application.mapper.ApiAccessLimitMapper;
import com.hand.hap.api.application.service.IApiAccessLimitService;
import com.hand.hap.api.gateway.dto.ApiInterface;
import com.hand.hap.api.gateway.dto.ApiServer;
import com.hand.hap.cache.impl.ApiAccessLimitCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.security.oauth.dto.Oauth2ClientDetails;
import com.hand.hap.security.oauth.service.IOauth2ClientDetailsService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApiAccessLimitServiceImpl
extends BaseServiceImpl<ApiAccessLimit>
implements IApiAccessLimitService {
    @Autowired
    private ApiAccessLimitMapper accessLimitMapper;
    @Autowired
    private ApiAccessLimitCache apiAccessLimitCache;
    @Autowired
    private IOauth2ClientDetailsService oauth2ClientDetailsService;
    private static final Logger logger = LoggerFactory.getLogger(ApiAccessLimitServiceImpl.class);

    @Transactional(rollbackFor={Exception.class})
    public List<ApiAccessLimit> batchUpdate(IRequest request, List<ApiAccessLimit> apiAccessLimitList) {
        for (ApiAccessLimit apiAccessLimit : apiAccessLimitList) {
            if (apiAccessLimit.getId() == null) {
                ((IApiAccessLimitService)this.self()).insertSelective(request, (Object)apiAccessLimit);
            } else {
                ((IApiAccessLimitService)this.self()).updateByPrimaryKey(request, (Object)apiAccessLimit);
            }
            this.apiAccessLimitCache.setValue(apiAccessLimit);
        }
        return apiAccessLimitList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateByApplication(String before, @StdWho ApiApplication apiApplication) {
        String after = apiApplication.getClient().getScope();
        String clientId = apiApplication.getClient().getClientId();
        logger.info("updateByApplication");
        List<String> befores = Arrays.asList(before.split(","));
        List<String> afters = Arrays.asList(after.split(","));
        ArrayList changeCode = new ArrayList();
        befores.forEach(item -> {
            if (!afters.contains(item)) {
                changeCode.add(item);
            }
        });
        changeCode.forEach(code -> {
            String key = clientId + "_" + code;
            this.apiAccessLimitCache.remove(key);
            ApiAccessLimit apiAccessLimit = new ApiAccessLimit();
            apiAccessLimit.setClientId(clientId);
            apiAccessLimit.setServerCode(code);
            this.accessLimitMapper.removeByClientIdAndServerCode(apiAccessLimit);
        });
        changeCode.clear();
        afters.forEach(item -> {
            if (!StringUtils.isEmpty((String)item) && !befores.contains(item)) {
                changeCode.add(item);
            }
        });
        changeCode.forEach(code -> {
            List apiInterfaces;
            ApiServer apiServer = null;
            if (null != apiApplication.getServers()) {
                apiServer = apiApplication.getServers().stream().filter(server -> server.getCode().equalsIgnoreCase((String)code)).findFirst().get();
            }
            ArrayList<ApiAccessLimit> apiAccessLimits = new ArrayList<ApiAccessLimit>();
            if (null != apiServer && null != (apiInterfaces = apiServer.getInterfaces())) {
                for (ApiInterface apiInterface : apiInterfaces) {
                    ApiAccessLimit apiAccessLimit2 = apiInterface.getApiAccessLimit();
                    apiAccessLimit2.setClientId(clientId);
                    apiAccessLimit2.setServerCode(code);
                    apiAccessLimit2.setInterfaceCode(apiInterface.getCode());
                    apiAccessLimits.add(apiAccessLimit2);
                }
            }
            if (apiAccessLimits.size() == 0) {
                apiAccessLimits.addAll(this.selectLimit(code, clientId));
            } else {
                apiAccessLimits.forEach(apiAccessLimit -> this.accessLimitMapper.insertSelective(apiAccessLimit));
            }
            apiAccessLimits.forEach(accessLimit -> this.apiAccessLimitCache.setValue(accessLimit));
        });
    }

    private List<ApiAccessLimit> selectLimit(String code, String clientId) {
        List<Object> apiAccessLimits = new ArrayList<ApiAccessLimit>();
        ApiAccessLimit apiAccessLimit = new ApiAccessLimit();
        apiAccessLimit.setServerCode(code);
        apiAccessLimit.setClientId(clientId);
        List temp = this.accessLimitMapper.selectByClientIdAndServerCode(apiAccessLimit);
        if (temp != null && temp.size() > 0) {
            temp.forEach(t -> this.accessLimitMapper.insertSelective(t));
            apiAccessLimits = this.accessLimitMapper.selectList(apiAccessLimit);
        }
        return apiAccessLimits;
    }

    @Transactional(rollbackFor={Exception.class})
    public int removeByClientId(Long id) {
        String[] scope;
        logger.info("deleteByClientId : " + id);
        Oauth2ClientDetails oauth2ClientDetails = this.oauth2ClientDetailsService.selectById(id);
        String clientId = oauth2ClientDetails.getClientId();
        for (String key : scope = oauth2ClientDetails.getScope().split(",")) {
            this.apiAccessLimitCache.remove(clientId + "_" + key);
        }
        ApiAccessLimit apiAccessLimit = new ApiAccessLimit();
        apiAccessLimit.setClientId(clientId);
        return this.accessLimitMapper.removeByClientIdAndServerCode(apiAccessLimit);
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateAccessLimit(IRequest iRequest, ApiApplication apiApplication) {
        List servers = apiApplication.getServers();
        String clientId = apiApplication.getClient().getClientId();
        if (null == servers) {
            return 0;
        }
        servers.stream().forEach(server -> {
            String serverCode = server.getCode();
            List interfaces = server.getInterfaces();
            if (null != interfaces) {
                interfaces.stream().forEach(apiInterface -> {
                    ApiAccessLimit apiAccessLimit = apiInterface.getApiAccessLimit();
                    String interfaceCode = apiInterface.getCode();
                    apiAccessLimit.setServerCode(serverCode);
                    apiAccessLimit.setInterfaceCode(interfaceCode);
                    if (null == apiAccessLimit.getClientId()) {
                        apiAccessLimit.setClientId(clientId);
                        this.mapper.insert((Object)apiAccessLimit);
                    }
                    this.updateRedisAccessLimit(apiAccessLimit);
                });
            }
        });
        return 0;
    }

    @Transactional(rollbackFor={Exception.class})
    private void updateRedisAccessLimit(ApiAccessLimit apiAccessLimit) {
        this.accessLimitMapper.updateByPrimaryKey((Object)apiAccessLimit);
        String key = apiAccessLimit.getClientId() + "_" + apiAccessLimit.getServerCode();
        HashMap<String, ApiAccessLimit> apiAccessLimitMap = (HashMap<String, ApiAccessLimit>)this.apiAccessLimitCache.getValue(key);
        if (null == apiAccessLimitMap) {
            apiAccessLimitMap = new HashMap<String, ApiAccessLimit>(2);
        }
        apiAccessLimitMap.put(apiAccessLimit.getInterfaceCode(), apiAccessLimit);
        this.apiAccessLimitCache.setValue(key, apiAccessLimitMap);
    }
}

