/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.service.impl;

import com.hand.hap.activiti.core.IActivitiConstants;
import com.hand.hap.activiti.custom.IActivitiBean;
import com.hand.hap.activiti.dto.ApproveChainHeader;
import com.hand.hap.activiti.dto.ApproveChainLine;
import com.hand.hap.activiti.service.IApproveChainHeaderService;
import com.hand.hap.activiti.service.IApproveChainLineService;
import com.hand.hap.activiti.service.impl.HapApproveChain;
import com.hand.hap.core.impl.RequestHelper;
import java.util.List;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HapApproveChain
implements IActivitiBean,
IActivitiConstants {
    private Logger logger = LoggerFactory.getLogger(HapApproveChain.class);
    private static String CURRENT_CHAIN_ID_PREFIX = "currentChainLineId_";
    private static String NO = "N";
    private static String YES = "Y";
    private static ThreadLocal<ApproveChainHolder> CHAIN_NEXT = new ThreadLocal();
    public static ThreadLocal<ApproveChainLine> CURRENT_LINE = new ThreadLocal();
    private boolean enableApproveChain = true;
    @Autowired
    IApproveChainHeaderService approveChainHeaderService;
    @Autowired
    IApproveChainLineService approveChainLineService;

    public String execute(DelegateExecution execution, String userTaskId) {
        ApproveChainLine nextLine;
        if (!this.enableApproveChain) {
            return NO;
        }
        if (this.isRejected((String)execution.getVariable("approveResult"))) {
            this.logger.debug("approve rejected, skip approve chain");
            return NO;
        }
        ApproveChainHeader approveChainHeader = this.approveChainHeaderService.selectByUserTask(StringUtils.substringBefore((String)execution.getProcessDefinitionId(), (String)":"), userTaskId);
        if (approveChainHeader == null) {
            this.logger.debug("UserTask has no related approve chain");
            return NO;
        }
        List chainLines = this.approveChainLineService.selectByHeaderId(RequestHelper.getCurrentRequest((boolean)true), approveChainHeader.getApproveChainId());
        if (chainLines.isEmpty()) {
            this.logger.warn("UserTask has no active approve chain line.");
            return NO;
        }
        Long currentLineId = (Long)execution.getVariable(CURRENT_CHAIN_ID_PREFIX + userTaskId);
        int nextIndex = 0;
        for (ApproveChainLine line : chainLines) {
            ++nextIndex;
            if (!line.getApproveChainLineId().equals(currentLineId)) continue;
            break;
        }
        if ((nextLine = this.getNextAvailableLine(execution, chainLines, nextIndex)) != null) {
            ApproveChainHolder next = new ApproveChainHolder();
            next.chainLine = nextLine;
            CHAIN_NEXT.set(next);
            this.logger.debug("next approve chain line :" + next.chainLine);
            return YES;
        }
        this.logger.debug("no more approve chain line available");
        return NO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ApproveChainLine getNextAvailableLine(DelegateExecution execution, List<ApproveChainLine> chainLines, int startIdx) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        while (startIdx < chainLines.size()) {
            ApproveChainLine line = chainLines.get(startIdx);
            if (!StringUtils.isNotEmpty((String)line.getSkipExpression())) return line;
            Object result = expressionManager.createExpression(line.getSkipExpression()).getValue((VariableScope)execution);
            if (!Boolean.TRUE.equals(result)) return line;
            this.logger.debug("skip approve chain : " + line);
            if ("Y".equalsIgnoreCase(line.getBreakOnSkip())) {
                this.logger.info("chain loop stopped, due to previous skipped line.");
                return null;
            }
            ++startIdx;
        }
        return null;
    }

    public void onTaskStart(DelegateExecution execution) {
        ApproveChainLine currentLine;
        if (!this.enableApproveChain) {
            return;
        }
        UserTask userTask = (UserTask)execution.getCurrentFlowElement();
        ApproveChainHolder holder = (ApproveChainHolder)CHAIN_NEXT.get();
        CHAIN_NEXT.remove();
        if (holder == null) {
            ApproveChainHeader approveChainHeader = this.approveChainHeaderService.selectByUserTask(StringUtils.substringBefore((String)execution.getProcessDefinitionId(), (String)":"), userTask.getId());
            if (approveChainHeader == null) {
                this.logger.debug("{} has no related approve chain", (Object)userTask);
                return;
            }
            List chainLines = this.approveChainLineService.selectByHeaderId(RequestHelper.getCurrentRequest((boolean)true), approveChainHeader.getApproveChainId());
            if (chainLines.isEmpty()) {
                this.logger.warn("{} has no active approve chain line.", (Object)userTask);
                return;
            }
            currentLine = this.getNextAvailableLine(execution, chainLines, 0);
            if (currentLine == null) {
                this.logger.warn("all approve chain are skipped");
                return;
            }
        } else {
            currentLine = holder.chainLine;
        }
        this.logger.debug("[{}] approve chain loop:{}", (Object)userTask.getName(), (Object)currentLine);
        CURRENT_LINE.set(currentLine);
        execution.setVariable(CURRENT_CHAIN_ID_PREFIX + userTask.getId(), (Object)currentLine.getApproveChainLineId());
    }
}

